/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.purestorageblock.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.purestorageblock.fluent.AvsVmsClient;
import com.azure.resourcemanager.purestorageblock.fluent.models.AvsVmInner;
import com.azure.resourcemanager.purestorageblock.implementation.PureStorageBlockMgmtClientImpl;
import com.azure.resourcemanager.purestorageblock.implementation.models.AvsVmListResult;
import com.azure.resourcemanager.purestorageblock.models.AvsVmUpdate;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class AvsVmsClientImpl
implements AvsVmsClient {
    private final AvsVmsService service;
    private final PureStorageBlockMgmtClientImpl client;
    private static final ClientLogger LOGGER = new ClientLogger(AvsVmsClientImpl.class);

    AvsVmsClientImpl(PureStorageBlockMgmtClientImpl client) {
        this.service = (AvsVmsService)RestProxy.create(AvsVmsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String storagePoolName, String avsVmId, AvsVmUpdate properties) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (storagePoolName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter storagePoolName is required and cannot be null."));
        }
        if (avsVmId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter avsVmId is required and cannot be null."));
        }
        if (properties == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter properties is required and cannot be null."));
        }
        properties.validate();
        String contentType = "application/json";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.update(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, storagePoolName, avsVmId, "application/json", "application/json", properties, (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> updateWithResponse(String resourceGroupName, String storagePoolName, String avsVmId, AvsVmUpdate properties) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (storagePoolName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter storagePoolName is required and cannot be null."));
        }
        if (avsVmId == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter avsVmId is required and cannot be null."));
        }
        if (properties == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter properties is required and cannot be null."));
        }
        properties.validate();
        String contentType = "application/json";
        String accept = "application/json";
        return this.service.updateSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, storagePoolName, avsVmId, "application/json", "application/json", properties, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> updateWithResponse(String resourceGroupName, String storagePoolName, String avsVmId, AvsVmUpdate properties, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (storagePoolName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter storagePoolName is required and cannot be null."));
        }
        if (avsVmId == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter avsVmId is required and cannot be null."));
        }
        if (properties == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter properties is required and cannot be null."));
        }
        properties.validate();
        String contentType = "application/json";
        String accept = "application/json";
        return this.service.updateSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, storagePoolName, avsVmId, "application/json", "application/json", properties, context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<AvsVmInner>, AvsVmInner> beginUpdateAsync(String resourceGroupName, String storagePoolName, String avsVmId, AvsVmUpdate properties) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, storagePoolName, avsVmId, properties);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)AvsVmInner.class), (Type)((Object)AvsVmInner.class), this.client.getContext());
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<AvsVmInner>, AvsVmInner> beginUpdate(String resourceGroupName, String storagePoolName, String avsVmId, AvsVmUpdate properties) {
        Response<BinaryData> response = this.updateWithResponse(resourceGroupName, storagePoolName, avsVmId, properties);
        return this.client.getLroResult(response, (Type)((Object)AvsVmInner.class), (Type)((Object)AvsVmInner.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<AvsVmInner>, AvsVmInner> beginUpdate(String resourceGroupName, String storagePoolName, String avsVmId, AvsVmUpdate properties, Context context) {
        Response<BinaryData> response = this.updateWithResponse(resourceGroupName, storagePoolName, avsVmId, properties, context);
        return this.client.getLroResult(response, (Type)((Object)AvsVmInner.class), (Type)((Object)AvsVmInner.class), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<AvsVmInner> updateAsync(String resourceGroupName, String storagePoolName, String avsVmId, AvsVmUpdate properties) {
        return this.beginUpdateAsync(resourceGroupName, storagePoolName, avsVmId, properties).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public AvsVmInner update(String resourceGroupName, String storagePoolName, String avsVmId, AvsVmUpdate properties) {
        return (AvsVmInner)((Object)this.beginUpdate(resourceGroupName, storagePoolName, avsVmId, properties).getFinalResult());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public AvsVmInner update(String resourceGroupName, String storagePoolName, String avsVmId, AvsVmUpdate properties, Context context) {
        return (AvsVmInner)((Object)this.beginUpdate(resourceGroupName, storagePoolName, avsVmId, properties, context).getFinalResult());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<AvsVmInner>> getWithResponseAsync(String resourceGroupName, String storagePoolName, String avsVmId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (storagePoolName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter storagePoolName is required and cannot be null."));
        }
        if (avsVmId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter avsVmId is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, storagePoolName, avsVmId, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<AvsVmInner> getAsync(String resourceGroupName, String storagePoolName, String avsVmId) {
        return this.getWithResponseAsync(resourceGroupName, storagePoolName, avsVmId).flatMap(res -> Mono.justOrEmpty((Object)((Object)((AvsVmInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<AvsVmInner> getWithResponse(String resourceGroupName, String storagePoolName, String avsVmId, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (storagePoolName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter storagePoolName is required and cannot be null."));
        }
        if (avsVmId == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter avsVmId is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.getSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, storagePoolName, avsVmId, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public AvsVmInner get(String resourceGroupName, String storagePoolName, String avsVmId) {
        return (AvsVmInner)((Object)this.getWithResponse(resourceGroupName, storagePoolName, avsVmId, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String storagePoolName, String avsVmId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (storagePoolName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter storagePoolName is required and cannot be null."));
        }
        if (avsVmId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter avsVmId is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, storagePoolName, avsVmId, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> deleteWithResponse(String resourceGroupName, String storagePoolName, String avsVmId) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (storagePoolName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter storagePoolName is required and cannot be null."));
        }
        if (avsVmId == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter avsVmId is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.deleteSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, storagePoolName, avsVmId, "application/json", Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> deleteWithResponse(String resourceGroupName, String storagePoolName, String avsVmId, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (storagePoolName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter storagePoolName is required and cannot be null."));
        }
        if (avsVmId == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter avsVmId is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.deleteSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, storagePoolName, avsVmId, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String storagePoolName, String avsVmId) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, storagePoolName, avsVmId);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String storagePoolName, String avsVmId) {
        Response<BinaryData> response = this.deleteWithResponse(resourceGroupName, storagePoolName, avsVmId);
        return this.client.getLroResult(response, (Type)((Object)Void.class), (Type)((Object)Void.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String storagePoolName, String avsVmId, Context context) {
        Response<BinaryData> response = this.deleteWithResponse(resourceGroupName, storagePoolName, avsVmId, context);
        return this.client.getLroResult(response, (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String storagePoolName, String avsVmId) {
        return this.beginDeleteAsync(resourceGroupName, storagePoolName, avsVmId).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String storagePoolName, String avsVmId) {
        this.beginDelete(resourceGroupName, storagePoolName, avsVmId).getFinalResult();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String storagePoolName, String avsVmId, Context context) {
        this.beginDelete(resourceGroupName, storagePoolName, avsVmId, context).getFinalResult();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<AvsVmInner>> listByStoragePoolSinglePageAsync(String resourceGroupName, String storagePoolName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (storagePoolName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter storagePoolName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByStoragePool(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, storagePoolName, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AvsVmListResult)res.getValue()).value(), ((AvsVmListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<AvsVmInner> listByStoragePoolAsync(String resourceGroupName, String storagePoolName) {
        return new PagedFlux(() -> this.listByStoragePoolSinglePageAsync(resourceGroupName, storagePoolName), nextLink -> this.listByStoragePoolNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<AvsVmInner> listByStoragePoolSinglePage(String resourceGroupName, String storagePoolName) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (storagePoolName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter storagePoolName is required and cannot be null."));
        }
        String accept = "application/json";
        Response<AvsVmListResult> res = this.service.listByStoragePoolSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, storagePoolName, "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AvsVmListResult)res.getValue()).value(), ((AvsVmListResult)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<AvsVmInner> listByStoragePoolSinglePage(String resourceGroupName, String storagePoolName, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (storagePoolName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter storagePoolName is required and cannot be null."));
        }
        String accept = "application/json";
        Response<AvsVmListResult> res = this.service.listByStoragePoolSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, storagePoolName, "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AvsVmListResult)res.getValue()).value(), ((AvsVmListResult)res.getValue()).nextLink(), null);
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<AvsVmInner> listByStoragePool(String resourceGroupName, String storagePoolName) {
        return new PagedIterable(() -> this.listByStoragePoolSinglePage(resourceGroupName, storagePoolName), nextLink -> this.listByStoragePoolNextSinglePage((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<AvsVmInner> listByStoragePool(String resourceGroupName, String storagePoolName, Context context) {
        return new PagedIterable(() -> this.listByStoragePoolSinglePage(resourceGroupName, storagePoolName, context), nextLink -> this.listByStoragePoolNextSinglePage((String)nextLink, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<AvsVmInner>> listByStoragePoolNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByStoragePoolNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AvsVmListResult)res.getValue()).value(), ((AvsVmListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<AvsVmInner> listByStoragePoolNextSinglePage(String nextLink) {
        if (nextLink == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        Response<AvsVmListResult> res = this.service.listByStoragePoolNextSync(nextLink, this.client.getEndpoint(), "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AvsVmListResult)res.getValue()).value(), ((AvsVmListResult)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<AvsVmInner> listByStoragePoolNextSinglePage(String nextLink, Context context) {
        if (nextLink == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        Response<AvsVmListResult> res = this.service.listByStoragePoolNextSync(nextLink, this.client.getEndpoint(), "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AvsVmListResult)res.getValue()).value(), ((AvsVmListResult)res.getValue()).nextLink(), null);
    }

    @Host(value="{endpoint}")
    @ServiceInterface(name="PureStorageBlockMgmt")
    public static interface AvsVmsService {
        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/PureStorage.Block/storagePools/{storagePoolName}/avsVms/{avsVmId}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> update(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="storagePoolName") String var5, @PathParam(value="avsVmId") String var6, @HeaderParam(value="Content-Type") String var7, @HeaderParam(value="Accept") String var8, @BodyParam(value="application/json") AvsVmUpdate var9, Context var10);

        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/PureStorage.Block/storagePools/{storagePoolName}/avsVms/{avsVmId}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BinaryData> updateSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="storagePoolName") String var5, @PathParam(value="avsVmId") String var6, @HeaderParam(value="Content-Type") String var7, @HeaderParam(value="Accept") String var8, @BodyParam(value="application/json") AvsVmUpdate var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/PureStorage.Block/storagePools/{storagePoolName}/avsVms/{avsVmId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<AvsVmInner>> get(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="storagePoolName") String var5, @PathParam(value="avsVmId") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/PureStorage.Block/storagePools/{storagePoolName}/avsVms/{avsVmId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<AvsVmInner> getSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="storagePoolName") String var5, @PathParam(value="avsVmId") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/PureStorage.Block/storagePools/{storagePoolName}/avsVms/{avsVmId}")
        @ExpectedResponses(value={202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> delete(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="storagePoolName") String var5, @PathParam(value="avsVmId") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/PureStorage.Block/storagePools/{storagePoolName}/avsVms/{avsVmId}")
        @ExpectedResponses(value={202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BinaryData> deleteSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="storagePoolName") String var5, @PathParam(value="avsVmId") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/PureStorage.Block/storagePools/{storagePoolName}/avsVms")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<AvsVmListResult>> listByStoragePool(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="storagePoolName") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/PureStorage.Block/storagePools/{storagePoolName}/avsVms")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<AvsVmListResult> listByStoragePoolSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="storagePoolName") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<AvsVmListResult>> listByStoragePoolNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<AvsVmListResult> listByStoragePoolNextSync(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

