/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.purestorageblock.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.purestorageblock.PureStorageBlockManager;
import com.azure.resourcemanager.purestorageblock.fluent.AvsVmVolumesClient;
import com.azure.resourcemanager.purestorageblock.fluent.models.AvsVmVolumeInner;
import com.azure.resourcemanager.purestorageblock.implementation.AvsVmVolumeImpl;
import com.azure.resourcemanager.purestorageblock.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.purestorageblock.models.AvsVmVolume;
import com.azure.resourcemanager.purestorageblock.models.AvsVmVolumeUpdate;
import com.azure.resourcemanager.purestorageblock.models.AvsVmVolumes;

public final class AvsVmVolumesImpl
implements AvsVmVolumes {
    private static final ClientLogger LOGGER = new ClientLogger(AvsVmVolumesImpl.class);
    private final AvsVmVolumesClient innerClient;
    private final PureStorageBlockManager serviceManager;

    public AvsVmVolumesImpl(AvsVmVolumesClient innerClient, PureStorageBlockManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public AvsVmVolume update(String resourceGroupName, String storagePoolName, String avsVmId, String volumeId, AvsVmVolumeUpdate properties) {
        AvsVmVolumeInner inner = this.serviceClient().update(resourceGroupName, storagePoolName, avsVmId, volumeId, properties);
        if (inner != null) {
            return new AvsVmVolumeImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public AvsVmVolume update(String resourceGroupName, String storagePoolName, String avsVmId, String volumeId, AvsVmVolumeUpdate properties, Context context) {
        AvsVmVolumeInner inner = this.serviceClient().update(resourceGroupName, storagePoolName, avsVmId, volumeId, properties, context);
        if (inner != null) {
            return new AvsVmVolumeImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<AvsVmVolume> getWithResponse(String resourceGroupName, String storagePoolName, String avsVmId, String volumeId, Context context) {
        Response<AvsVmVolumeInner> inner = this.serviceClient().getWithResponse(resourceGroupName, storagePoolName, avsVmId, volumeId, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new AvsVmVolumeImpl((AvsVmVolumeInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public AvsVmVolume get(String resourceGroupName, String storagePoolName, String avsVmId, String volumeId) {
        AvsVmVolumeInner inner = this.serviceClient().get(resourceGroupName, storagePoolName, avsVmId, volumeId);
        if (inner != null) {
            return new AvsVmVolumeImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void delete(String resourceGroupName, String storagePoolName, String avsVmId, String volumeId) {
        this.serviceClient().delete(resourceGroupName, storagePoolName, avsVmId, volumeId);
    }

    @Override
    public void delete(String resourceGroupName, String storagePoolName, String avsVmId, String volumeId, Context context) {
        this.serviceClient().delete(resourceGroupName, storagePoolName, avsVmId, volumeId, context);
    }

    @Override
    public PagedIterable<AvsVmVolume> listByAvsVm(String resourceGroupName, String storagePoolName, String avsVmId) {
        PagedIterable<AvsVmVolumeInner> inner = this.serviceClient().listByAvsVm(resourceGroupName, storagePoolName, avsVmId);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new AvsVmVolumeImpl((AvsVmVolumeInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<AvsVmVolume> listByAvsVm(String resourceGroupName, String storagePoolName, String avsVmId, Context context) {
        PagedIterable<AvsVmVolumeInner> inner = this.serviceClient().listByAvsVm(resourceGroupName, storagePoolName, avsVmId, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new AvsVmVolumeImpl((AvsVmVolumeInner)((Object)inner1), this.manager()));
    }

    private AvsVmVolumesClient serviceClient() {
        return this.innerClient;
    }

    private PureStorageBlockManager manager() {
        return this.serviceManager;
    }
}

