/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.purestorageblock.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.purestorageblock.fluent.AvsVmVolumesClient;
import com.azure.resourcemanager.purestorageblock.fluent.models.AvsVmVolumeInner;
import com.azure.resourcemanager.purestorageblock.implementation.PureStorageBlockMgmtClientImpl;
import com.azure.resourcemanager.purestorageblock.implementation.models.AvsVmVolumeListResult;
import com.azure.resourcemanager.purestorageblock.models.AvsVmVolumeUpdate;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class AvsVmVolumesClientImpl
implements AvsVmVolumesClient {
    private final AvsVmVolumesService service;
    private final PureStorageBlockMgmtClientImpl client;
    private static final ClientLogger LOGGER = new ClientLogger(AvsVmVolumesClientImpl.class);

    AvsVmVolumesClientImpl(PureStorageBlockMgmtClientImpl client) {
        this.service = (AvsVmVolumesService)RestProxy.create(AvsVmVolumesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String storagePoolName, String avsVmId, String volumeId, AvsVmVolumeUpdate properties) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (storagePoolName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter storagePoolName is required and cannot be null."));
        }
        if (avsVmId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter avsVmId is required and cannot be null."));
        }
        if (volumeId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter volumeId is required and cannot be null."));
        }
        if (properties == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter properties is required and cannot be null."));
        }
        properties.validate();
        String contentType = "application/json";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.update(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, storagePoolName, avsVmId, volumeId, "application/json", "application/json", properties, (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> updateWithResponse(String resourceGroupName, String storagePoolName, String avsVmId, String volumeId, AvsVmVolumeUpdate properties) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (storagePoolName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter storagePoolName is required and cannot be null."));
        }
        if (avsVmId == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter avsVmId is required and cannot be null."));
        }
        if (volumeId == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter volumeId is required and cannot be null."));
        }
        if (properties == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter properties is required and cannot be null."));
        }
        properties.validate();
        String contentType = "application/json";
        String accept = "application/json";
        return this.service.updateSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, storagePoolName, avsVmId, volumeId, "application/json", "application/json", properties, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> updateWithResponse(String resourceGroupName, String storagePoolName, String avsVmId, String volumeId, AvsVmVolumeUpdate properties, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (storagePoolName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter storagePoolName is required and cannot be null."));
        }
        if (avsVmId == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter avsVmId is required and cannot be null."));
        }
        if (volumeId == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter volumeId is required and cannot be null."));
        }
        if (properties == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter properties is required and cannot be null."));
        }
        properties.validate();
        String contentType = "application/json";
        String accept = "application/json";
        return this.service.updateSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, storagePoolName, avsVmId, volumeId, "application/json", "application/json", properties, context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<AvsVmVolumeInner>, AvsVmVolumeInner> beginUpdateAsync(String resourceGroupName, String storagePoolName, String avsVmId, String volumeId, AvsVmVolumeUpdate properties) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, storagePoolName, avsVmId, volumeId, properties);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)AvsVmVolumeInner.class), (Type)((Object)AvsVmVolumeInner.class), this.client.getContext());
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<AvsVmVolumeInner>, AvsVmVolumeInner> beginUpdate(String resourceGroupName, String storagePoolName, String avsVmId, String volumeId, AvsVmVolumeUpdate properties) {
        Response<BinaryData> response = this.updateWithResponse(resourceGroupName, storagePoolName, avsVmId, volumeId, properties);
        return this.client.getLroResult(response, (Type)((Object)AvsVmVolumeInner.class), (Type)((Object)AvsVmVolumeInner.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<AvsVmVolumeInner>, AvsVmVolumeInner> beginUpdate(String resourceGroupName, String storagePoolName, String avsVmId, String volumeId, AvsVmVolumeUpdate properties, Context context) {
        Response<BinaryData> response = this.updateWithResponse(resourceGroupName, storagePoolName, avsVmId, volumeId, properties, context);
        return this.client.getLroResult(response, (Type)((Object)AvsVmVolumeInner.class), (Type)((Object)AvsVmVolumeInner.class), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<AvsVmVolumeInner> updateAsync(String resourceGroupName, String storagePoolName, String avsVmId, String volumeId, AvsVmVolumeUpdate properties) {
        return this.beginUpdateAsync(resourceGroupName, storagePoolName, avsVmId, volumeId, properties).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public AvsVmVolumeInner update(String resourceGroupName, String storagePoolName, String avsVmId, String volumeId, AvsVmVolumeUpdate properties) {
        return (AvsVmVolumeInner)((Object)this.beginUpdate(resourceGroupName, storagePoolName, avsVmId, volumeId, properties).getFinalResult());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public AvsVmVolumeInner update(String resourceGroupName, String storagePoolName, String avsVmId, String volumeId, AvsVmVolumeUpdate properties, Context context) {
        return (AvsVmVolumeInner)((Object)this.beginUpdate(resourceGroupName, storagePoolName, avsVmId, volumeId, properties, context).getFinalResult());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<AvsVmVolumeInner>> getWithResponseAsync(String resourceGroupName, String storagePoolName, String avsVmId, String volumeId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (storagePoolName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter storagePoolName is required and cannot be null."));
        }
        if (avsVmId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter avsVmId is required and cannot be null."));
        }
        if (volumeId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter volumeId is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, storagePoolName, avsVmId, volumeId, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<AvsVmVolumeInner> getAsync(String resourceGroupName, String storagePoolName, String avsVmId, String volumeId) {
        return this.getWithResponseAsync(resourceGroupName, storagePoolName, avsVmId, volumeId).flatMap(res -> Mono.justOrEmpty((Object)((Object)((AvsVmVolumeInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<AvsVmVolumeInner> getWithResponse(String resourceGroupName, String storagePoolName, String avsVmId, String volumeId, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (storagePoolName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter storagePoolName is required and cannot be null."));
        }
        if (avsVmId == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter avsVmId is required and cannot be null."));
        }
        if (volumeId == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter volumeId is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.getSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, storagePoolName, avsVmId, volumeId, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public AvsVmVolumeInner get(String resourceGroupName, String storagePoolName, String avsVmId, String volumeId) {
        return (AvsVmVolumeInner)((Object)this.getWithResponse(resourceGroupName, storagePoolName, avsVmId, volumeId, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String storagePoolName, String avsVmId, String volumeId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (storagePoolName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter storagePoolName is required and cannot be null."));
        }
        if (avsVmId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter avsVmId is required and cannot be null."));
        }
        if (volumeId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter volumeId is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, storagePoolName, avsVmId, volumeId, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> deleteWithResponse(String resourceGroupName, String storagePoolName, String avsVmId, String volumeId) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (storagePoolName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter storagePoolName is required and cannot be null."));
        }
        if (avsVmId == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter avsVmId is required and cannot be null."));
        }
        if (volumeId == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter volumeId is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.deleteSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, storagePoolName, avsVmId, volumeId, "application/json", Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> deleteWithResponse(String resourceGroupName, String storagePoolName, String avsVmId, String volumeId, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (storagePoolName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter storagePoolName is required and cannot be null."));
        }
        if (avsVmId == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter avsVmId is required and cannot be null."));
        }
        if (volumeId == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter volumeId is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.deleteSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, storagePoolName, avsVmId, volumeId, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String storagePoolName, String avsVmId, String volumeId) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, storagePoolName, avsVmId, volumeId);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String storagePoolName, String avsVmId, String volumeId) {
        Response<BinaryData> response = this.deleteWithResponse(resourceGroupName, storagePoolName, avsVmId, volumeId);
        return this.client.getLroResult(response, (Type)((Object)Void.class), (Type)((Object)Void.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String storagePoolName, String avsVmId, String volumeId, Context context) {
        Response<BinaryData> response = this.deleteWithResponse(resourceGroupName, storagePoolName, avsVmId, volumeId, context);
        return this.client.getLroResult(response, (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String storagePoolName, String avsVmId, String volumeId) {
        return this.beginDeleteAsync(resourceGroupName, storagePoolName, avsVmId, volumeId).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String storagePoolName, String avsVmId, String volumeId) {
        this.beginDelete(resourceGroupName, storagePoolName, avsVmId, volumeId).getFinalResult();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String storagePoolName, String avsVmId, String volumeId, Context context) {
        this.beginDelete(resourceGroupName, storagePoolName, avsVmId, volumeId, context).getFinalResult();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<AvsVmVolumeInner>> listByAvsVmSinglePageAsync(String resourceGroupName, String storagePoolName, String avsVmId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (storagePoolName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter storagePoolName is required and cannot be null."));
        }
        if (avsVmId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter avsVmId is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByAvsVm(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, storagePoolName, avsVmId, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AvsVmVolumeListResult)res.getValue()).value(), ((AvsVmVolumeListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<AvsVmVolumeInner> listByAvsVmAsync(String resourceGroupName, String storagePoolName, String avsVmId) {
        return new PagedFlux(() -> this.listByAvsVmSinglePageAsync(resourceGroupName, storagePoolName, avsVmId), nextLink -> this.listByAvsVmNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<AvsVmVolumeInner> listByAvsVmSinglePage(String resourceGroupName, String storagePoolName, String avsVmId) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (storagePoolName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter storagePoolName is required and cannot be null."));
        }
        if (avsVmId == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter avsVmId is required and cannot be null."));
        }
        String accept = "application/json";
        Response<AvsVmVolumeListResult> res = this.service.listByAvsVmSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, storagePoolName, avsVmId, "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AvsVmVolumeListResult)res.getValue()).value(), ((AvsVmVolumeListResult)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<AvsVmVolumeInner> listByAvsVmSinglePage(String resourceGroupName, String storagePoolName, String avsVmId, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (storagePoolName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter storagePoolName is required and cannot be null."));
        }
        if (avsVmId == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter avsVmId is required and cannot be null."));
        }
        String accept = "application/json";
        Response<AvsVmVolumeListResult> res = this.service.listByAvsVmSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, storagePoolName, avsVmId, "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AvsVmVolumeListResult)res.getValue()).value(), ((AvsVmVolumeListResult)res.getValue()).nextLink(), null);
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<AvsVmVolumeInner> listByAvsVm(String resourceGroupName, String storagePoolName, String avsVmId) {
        return new PagedIterable(() -> this.listByAvsVmSinglePage(resourceGroupName, storagePoolName, avsVmId), nextLink -> this.listByAvsVmNextSinglePage((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<AvsVmVolumeInner> listByAvsVm(String resourceGroupName, String storagePoolName, String avsVmId, Context context) {
        return new PagedIterable(() -> this.listByAvsVmSinglePage(resourceGroupName, storagePoolName, avsVmId, context), nextLink -> this.listByAvsVmNextSinglePage((String)nextLink, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<AvsVmVolumeInner>> listByAvsVmNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByAvsVmNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AvsVmVolumeListResult)res.getValue()).value(), ((AvsVmVolumeListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<AvsVmVolumeInner> listByAvsVmNextSinglePage(String nextLink) {
        if (nextLink == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        Response<AvsVmVolumeListResult> res = this.service.listByAvsVmNextSync(nextLink, this.client.getEndpoint(), "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AvsVmVolumeListResult)res.getValue()).value(), ((AvsVmVolumeListResult)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<AvsVmVolumeInner> listByAvsVmNextSinglePage(String nextLink, Context context) {
        if (nextLink == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        Response<AvsVmVolumeListResult> res = this.service.listByAvsVmNextSync(nextLink, this.client.getEndpoint(), "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AvsVmVolumeListResult)res.getValue()).value(), ((AvsVmVolumeListResult)res.getValue()).nextLink(), null);
    }

    @Host(value="{endpoint}")
    @ServiceInterface(name="PureStorageBlockMgmt")
    public static interface AvsVmVolumesService {
        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/PureStorage.Block/storagePools/{storagePoolName}/avsVms/{avsVmId}/avsVmVolumes/{volumeId}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> update(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="storagePoolName") String var5, @PathParam(value="avsVmId") String var6, @PathParam(value="volumeId") String var7, @HeaderParam(value="Content-Type") String var8, @HeaderParam(value="Accept") String var9, @BodyParam(value="application/json") AvsVmVolumeUpdate var10, Context var11);

        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/PureStorage.Block/storagePools/{storagePoolName}/avsVms/{avsVmId}/avsVmVolumes/{volumeId}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BinaryData> updateSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="storagePoolName") String var5, @PathParam(value="avsVmId") String var6, @PathParam(value="volumeId") String var7, @HeaderParam(value="Content-Type") String var8, @HeaderParam(value="Accept") String var9, @BodyParam(value="application/json") AvsVmVolumeUpdate var10, Context var11);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/PureStorage.Block/storagePools/{storagePoolName}/avsVms/{avsVmId}/avsVmVolumes/{volumeId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<AvsVmVolumeInner>> get(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="storagePoolName") String var5, @PathParam(value="avsVmId") String var6, @PathParam(value="volumeId") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/PureStorage.Block/storagePools/{storagePoolName}/avsVms/{avsVmId}/avsVmVolumes/{volumeId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<AvsVmVolumeInner> getSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="storagePoolName") String var5, @PathParam(value="avsVmId") String var6, @PathParam(value="volumeId") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/PureStorage.Block/storagePools/{storagePoolName}/avsVms/{avsVmId}/avsVmVolumes/{volumeId}")
        @ExpectedResponses(value={202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> delete(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="storagePoolName") String var5, @PathParam(value="avsVmId") String var6, @PathParam(value="volumeId") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/PureStorage.Block/storagePools/{storagePoolName}/avsVms/{avsVmId}/avsVmVolumes/{volumeId}")
        @ExpectedResponses(value={202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BinaryData> deleteSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="storagePoolName") String var5, @PathParam(value="avsVmId") String var6, @PathParam(value="volumeId") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/PureStorage.Block/storagePools/{storagePoolName}/avsVms/{avsVmId}/avsVmVolumes")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<AvsVmVolumeListResult>> listByAvsVm(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="storagePoolName") String var5, @PathParam(value="avsVmId") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/PureStorage.Block/storagePools/{storagePoolName}/avsVms/{avsVmId}/avsVmVolumes")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<AvsVmVolumeListResult> listByAvsVmSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="storagePoolName") String var5, @PathParam(value="avsVmId") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<AvsVmVolumeListResult>> listByAvsVmNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<AvsVmVolumeListResult> listByAvsVmNextSync(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

