/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.purestorageblock.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.purestorageblock.PureStorageBlockManager;
import com.azure.resourcemanager.purestorageblock.fluent.AvsStorageContainersClient;
import com.azure.resourcemanager.purestorageblock.fluent.models.AvsStorageContainerInner;
import com.azure.resourcemanager.purestorageblock.implementation.AvsStorageContainerImpl;
import com.azure.resourcemanager.purestorageblock.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.purestorageblock.models.AvsStorageContainer;
import com.azure.resourcemanager.purestorageblock.models.AvsStorageContainers;

public final class AvsStorageContainersImpl
implements AvsStorageContainers {
    private static final ClientLogger LOGGER = new ClientLogger(AvsStorageContainersImpl.class);
    private final AvsStorageContainersClient innerClient;
    private final PureStorageBlockManager serviceManager;

    public AvsStorageContainersImpl(AvsStorageContainersClient innerClient, PureStorageBlockManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<AvsStorageContainer> getWithResponse(String resourceGroupName, String storagePoolName, String storageContainerName, Context context) {
        Response<AvsStorageContainerInner> inner = this.serviceClient().getWithResponse(resourceGroupName, storagePoolName, storageContainerName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new AvsStorageContainerImpl((AvsStorageContainerInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public AvsStorageContainer get(String resourceGroupName, String storagePoolName, String storageContainerName) {
        AvsStorageContainerInner inner = this.serviceClient().get(resourceGroupName, storagePoolName, storageContainerName);
        if (inner != null) {
            return new AvsStorageContainerImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void delete(String resourceGroupName, String storagePoolName, String storageContainerName) {
        this.serviceClient().delete(resourceGroupName, storagePoolName, storageContainerName);
    }

    @Override
    public void delete(String resourceGroupName, String storagePoolName, String storageContainerName, Context context) {
        this.serviceClient().delete(resourceGroupName, storagePoolName, storageContainerName, context);
    }

    @Override
    public PagedIterable<AvsStorageContainer> listByStoragePool(String resourceGroupName, String storagePoolName) {
        PagedIterable<AvsStorageContainerInner> inner = this.serviceClient().listByStoragePool(resourceGroupName, storagePoolName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new AvsStorageContainerImpl((AvsStorageContainerInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<AvsStorageContainer> listByStoragePool(String resourceGroupName, String storagePoolName, Context context) {
        PagedIterable<AvsStorageContainerInner> inner = this.serviceClient().listByStoragePool(resourceGroupName, storagePoolName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new AvsStorageContainerImpl((AvsStorageContainerInner)((Object)inner1), this.manager()));
    }

    private AvsStorageContainersClient serviceClient() {
        return this.innerClient;
    }

    private PureStorageBlockManager manager() {
        return this.serviceManager;
    }
}

