/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.purestorageblock.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.purestorageblock.PureStorageBlockManager;
import com.azure.resourcemanager.purestorageblock.fluent.AvsStorageContainerVolumesClient;
import com.azure.resourcemanager.purestorageblock.fluent.models.AvsStorageContainerVolumeInner;
import com.azure.resourcemanager.purestorageblock.implementation.AvsStorageContainerVolumeImpl;
import com.azure.resourcemanager.purestorageblock.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.purestorageblock.models.AvsStorageContainerVolume;
import com.azure.resourcemanager.purestorageblock.models.AvsStorageContainerVolumeUpdate;
import com.azure.resourcemanager.purestorageblock.models.AvsStorageContainerVolumes;

public final class AvsStorageContainerVolumesImpl
implements AvsStorageContainerVolumes {
    private static final ClientLogger LOGGER = new ClientLogger(AvsStorageContainerVolumesImpl.class);
    private final AvsStorageContainerVolumesClient innerClient;
    private final PureStorageBlockManager serviceManager;

    public AvsStorageContainerVolumesImpl(AvsStorageContainerVolumesClient innerClient, PureStorageBlockManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public AvsStorageContainerVolume update(String resourceGroupName, String storagePoolName, String storageContainerName, String volumeId, AvsStorageContainerVolumeUpdate properties) {
        AvsStorageContainerVolumeInner inner = this.serviceClient().update(resourceGroupName, storagePoolName, storageContainerName, volumeId, properties);
        if (inner != null) {
            return new AvsStorageContainerVolumeImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public AvsStorageContainerVolume update(String resourceGroupName, String storagePoolName, String storageContainerName, String volumeId, AvsStorageContainerVolumeUpdate properties, Context context) {
        AvsStorageContainerVolumeInner inner = this.serviceClient().update(resourceGroupName, storagePoolName, storageContainerName, volumeId, properties, context);
        if (inner != null) {
            return new AvsStorageContainerVolumeImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<AvsStorageContainerVolume> getWithResponse(String resourceGroupName, String storagePoolName, String storageContainerName, String volumeId, Context context) {
        Response<AvsStorageContainerVolumeInner> inner = this.serviceClient().getWithResponse(resourceGroupName, storagePoolName, storageContainerName, volumeId, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new AvsStorageContainerVolumeImpl((AvsStorageContainerVolumeInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public AvsStorageContainerVolume get(String resourceGroupName, String storagePoolName, String storageContainerName, String volumeId) {
        AvsStorageContainerVolumeInner inner = this.serviceClient().get(resourceGroupName, storagePoolName, storageContainerName, volumeId);
        if (inner != null) {
            return new AvsStorageContainerVolumeImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void delete(String resourceGroupName, String storagePoolName, String storageContainerName, String volumeId) {
        this.serviceClient().delete(resourceGroupName, storagePoolName, storageContainerName, volumeId);
    }

    @Override
    public void delete(String resourceGroupName, String storagePoolName, String storageContainerName, String volumeId, Context context) {
        this.serviceClient().delete(resourceGroupName, storagePoolName, storageContainerName, volumeId, context);
    }

    @Override
    public PagedIterable<AvsStorageContainerVolume> listByAvsStorageContainer(String resourceGroupName, String storagePoolName, String storageContainerName) {
        PagedIterable<AvsStorageContainerVolumeInner> inner = this.serviceClient().listByAvsStorageContainer(resourceGroupName, storagePoolName, storageContainerName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new AvsStorageContainerVolumeImpl((AvsStorageContainerVolumeInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<AvsStorageContainerVolume> listByAvsStorageContainer(String resourceGroupName, String storagePoolName, String storageContainerName, Context context) {
        PagedIterable<AvsStorageContainerVolumeInner> inner = this.serviceClient().listByAvsStorageContainer(resourceGroupName, storagePoolName, storageContainerName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new AvsStorageContainerVolumeImpl((AvsStorageContainerVolumeInner)((Object)inner1), this.manager()));
    }

    private AvsStorageContainerVolumesClient serviceClient() {
        return this.innerClient;
    }

    private PureStorageBlockManager manager() {
        return this.serviceManager;
    }
}

