/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.purestorageblock.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.purestorageblock.models.Alert;
import com.azure.resourcemanager.purestorageblock.models.HealthDetails;
import java.io.IOException;
import java.util.List;

public final class StoragePoolHealthInfoInner
implements JsonSerializable<StoragePoolHealthInfoInner> {
    private HealthDetails health;
    private List<Alert> alerts;
    private static final ClientLogger LOGGER = new ClientLogger(StoragePoolHealthInfoInner.class);

    private StoragePoolHealthInfoInner() {
    }

    public HealthDetails health() {
        return this.health;
    }

    public List<Alert> alerts() {
        return this.alerts;
    }

    public void validate() {
        if (this.health() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property health in model StoragePoolHealthInfoInner"));
        }
        this.health().validate();
        if (this.alerts() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property alerts in model StoragePoolHealthInfoInner"));
        }
        this.alerts().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("health", (JsonSerializable)this.health);
        jsonWriter.writeArrayField("alerts", this.alerts, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static StoragePoolHealthInfoInner fromJson(JsonReader jsonReader) throws IOException {
        return (StoragePoolHealthInfoInner)jsonReader.readObject(reader -> {
            StoragePoolHealthInfoInner deserializedStoragePoolHealthInfoInner = new StoragePoolHealthInfoInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("health".equals(fieldName)) {
                    deserializedStoragePoolHealthInfoInner.health = HealthDetails.fromJson(reader);
                    continue;
                }
                if ("alerts".equals(fieldName)) {
                    List alerts;
                    deserializedStoragePoolHealthInfoInner.alerts = alerts = reader.readArray(reader1 -> Alert.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedStoragePoolHealthInfoInner;
        });
    }
}

