/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.purestorageblock.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.purestorageblock.models.ReservationPropertiesBaseResourceProperties;
import java.io.IOException;
import java.util.Map;

public final class ReservationInner
extends Resource {
    private ReservationPropertiesBaseResourceProperties properties;
    private SystemData systemData;
    private String type;
    private String name;
    private String id;

    public ReservationPropertiesBaseResourceProperties properties() {
        return this.properties;
    }

    public ReservationInner withProperties(ReservationPropertiesBaseResourceProperties properties) {
        this.properties = properties;
        return this;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public ReservationInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public ReservationInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public void validate() {
        if (this.properties() != null) {
            this.properties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.properties);
        return jsonWriter.writeEndObject();
    }

    public static ReservationInner fromJson(JsonReader jsonReader) throws IOException {
        return (ReservationInner)((Object)jsonReader.readObject(reader -> {
            ReservationInner deserializedReservationInner = new ReservationInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedReservationInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedReservationInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedReservationInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedReservationInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedReservationInner.withTags(tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedReservationInner.properties = ReservationPropertiesBaseResourceProperties.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedReservationInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedReservationInner;
        }));
    }
}

