/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.purestorageblock.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.purestorageblock.models.BillingUsageProperty;
import java.io.IOException;
import java.util.List;

public final class ReservationBillingUsageReportInner
implements JsonSerializable<ReservationBillingUsageReportInner> {
    private String timestamp;
    private List<BillingUsageProperty> billingUsageProperties;
    private String overallStatusMessage;
    private static final ClientLogger LOGGER = new ClientLogger(ReservationBillingUsageReportInner.class);

    private ReservationBillingUsageReportInner() {
    }

    public String timestamp() {
        return this.timestamp;
    }

    public List<BillingUsageProperty> billingUsageProperties() {
        return this.billingUsageProperties;
    }

    public String overallStatusMessage() {
        return this.overallStatusMessage;
    }

    public void validate() {
        if (this.timestamp() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property timestamp in model ReservationBillingUsageReportInner"));
        }
        if (this.billingUsageProperties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property billingUsageProperties in model ReservationBillingUsageReportInner"));
        }
        this.billingUsageProperties().forEach(e -> e.validate());
        if (this.overallStatusMessage() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property overallStatusMessage in model ReservationBillingUsageReportInner"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("timestamp", this.timestamp);
        jsonWriter.writeArrayField("billingUsageProperties", this.billingUsageProperties, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("overallStatusMessage", this.overallStatusMessage);
        return jsonWriter.writeEndObject();
    }

    public static ReservationBillingUsageReportInner fromJson(JsonReader jsonReader) throws IOException {
        return (ReservationBillingUsageReportInner)jsonReader.readObject(reader -> {
            ReservationBillingUsageReportInner deserializedReservationBillingUsageReportInner = new ReservationBillingUsageReportInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("timestamp".equals(fieldName)) {
                    deserializedReservationBillingUsageReportInner.timestamp = reader.getString();
                    continue;
                }
                if ("billingUsageProperties".equals(fieldName)) {
                    List billingUsageProperties;
                    deserializedReservationBillingUsageReportInner.billingUsageProperties = billingUsageProperties = reader.readArray(reader1 -> BillingUsageProperty.fromJson(reader1));
                    continue;
                }
                if ("overallStatusMessage".equals(fieldName)) {
                    deserializedReservationBillingUsageReportInner.overallStatusMessage = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedReservationBillingUsageReportInner;
        });
    }
}

