/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.purestorageblock.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.purestorageblock.models.PerformancePolicyLimits;
import com.azure.resourcemanager.purestorageblock.models.ProtectionPolicyLimits;
import com.azure.resourcemanager.purestorageblock.models.StoragePoolLimits;
import com.azure.resourcemanager.purestorageblock.models.VolumeLimits;
import java.io.IOException;

public final class LimitDetailsInner
implements JsonSerializable<LimitDetailsInner> {
    private StoragePoolLimits storagePool;
    private VolumeLimits volume;
    private ProtectionPolicyLimits protectionPolicy;
    private PerformancePolicyLimits performancePolicy;
    private static final ClientLogger LOGGER = new ClientLogger(LimitDetailsInner.class);

    private LimitDetailsInner() {
    }

    public StoragePoolLimits storagePool() {
        return this.storagePool;
    }

    public VolumeLimits volume() {
        return this.volume;
    }

    public ProtectionPolicyLimits protectionPolicy() {
        return this.protectionPolicy;
    }

    public PerformancePolicyLimits performancePolicy() {
        return this.performancePolicy;
    }

    public void validate() {
        if (this.storagePool() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property storagePool in model LimitDetailsInner"));
        }
        this.storagePool().validate();
        if (this.volume() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property volume in model LimitDetailsInner"));
        }
        this.volume().validate();
        if (this.protectionPolicy() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property protectionPolicy in model LimitDetailsInner"));
        }
        this.protectionPolicy().validate();
        if (this.performancePolicy() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property performancePolicy in model LimitDetailsInner"));
        }
        this.performancePolicy().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("storagePool", (JsonSerializable)this.storagePool);
        jsonWriter.writeJsonField("volume", (JsonSerializable)this.volume);
        jsonWriter.writeJsonField("protectionPolicy", (JsonSerializable)this.protectionPolicy);
        jsonWriter.writeJsonField("performancePolicy", (JsonSerializable)this.performancePolicy);
        return jsonWriter.writeEndObject();
    }

    public static LimitDetailsInner fromJson(JsonReader jsonReader) throws IOException {
        return (LimitDetailsInner)jsonReader.readObject(reader -> {
            LimitDetailsInner deserializedLimitDetailsInner = new LimitDetailsInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("storagePool".equals(fieldName)) {
                    deserializedLimitDetailsInner.storagePool = StoragePoolLimits.fromJson(reader);
                    continue;
                }
                if ("volume".equals(fieldName)) {
                    deserializedLimitDetailsInner.volume = VolumeLimits.fromJson(reader);
                    continue;
                }
                if ("protectionPolicy".equals(fieldName)) {
                    deserializedLimitDetailsInner.protectionPolicy = ProtectionPolicyLimits.fromJson(reader);
                    continue;
                }
                if ("performancePolicy".equals(fieldName)) {
                    deserializedLimitDetailsInner.performancePolicy = PerformancePolicyLimits.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedLimitDetailsInner;
        });
    }
}

