/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.providerhub.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class TypedErrorInfo
implements JsonSerializable<TypedErrorInfo> {
    private String type;
    private Object info;
    private static final ClientLogger LOGGER = new ClientLogger(TypedErrorInfo.class);

    public String type() {
        return this.type;
    }

    public TypedErrorInfo withType(String type) {
        this.type = type;
        return this;
    }

    public Object info() {
        return this.info;
    }

    public void validate() {
        if (this.type() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property type in model TypedErrorInfo"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type);
        return jsonWriter.writeEndObject();
    }

    public static TypedErrorInfo fromJson(JsonReader jsonReader) throws IOException {
        return (TypedErrorInfo)jsonReader.readObject(reader -> {
            TypedErrorInfo deserializedTypedErrorInfo = new TypedErrorInfo();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedTypedErrorInfo.type = reader.getString();
                    continue;
                }
                if ("info".equals(fieldName)) {
                    deserializedTypedErrorInfo.info = reader.readUntyped();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedTypedErrorInfo;
        });
    }
}

