/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.providerhub.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.providerhub.models.TrafficRegions;
import java.io.IOException;
import java.time.Duration;
import java.util.List;

public class TrafficRegionRolloutConfiguration
extends TrafficRegions {
    private Duration waitDuration;

    public Duration waitDuration() {
        return this.waitDuration;
    }

    public TrafficRegionRolloutConfiguration withWaitDuration(Duration waitDuration) {
        this.waitDuration = waitDuration;
        return this;
    }

    @Override
    public TrafficRegionRolloutConfiguration withRegions(List<String> regions) {
        super.withRegions(regions);
        return this;
    }

    @Override
    public void validate() {
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("regions", this.regions(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("waitDuration", CoreUtils.durationToStringWithDays((Duration)this.waitDuration));
        return jsonWriter.writeEndObject();
    }

    public static TrafficRegionRolloutConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return (TrafficRegionRolloutConfiguration)jsonReader.readObject(reader -> {
            TrafficRegionRolloutConfiguration deserializedTrafficRegionRolloutConfiguration = new TrafficRegionRolloutConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("regions".equals(fieldName)) {
                    List regions = reader.readArray(reader1 -> reader1.getString());
                    deserializedTrafficRegionRolloutConfiguration.withRegions(regions);
                    continue;
                }
                if ("waitDuration".equals(fieldName)) {
                    deserializedTrafficRegionRolloutConfiguration.waitDuration = (Duration)reader.getNullable(nonNullReader -> Duration.parse(nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedTrafficRegionRolloutConfiguration;
        });
    }
}

