/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.providerhub.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.providerhub.models.AuthenticationScheme;
import com.azure.resourcemanager.providerhub.models.SignedRequestScope;
import java.io.IOException;

public final class TokenAuthConfiguration
implements JsonSerializable<TokenAuthConfiguration> {
    private AuthenticationScheme authenticationScheme;
    private SignedRequestScope signedRequestScope;
    private Boolean disableCertificateAuthenticationFallback;

    public AuthenticationScheme authenticationScheme() {
        return this.authenticationScheme;
    }

    public TokenAuthConfiguration withAuthenticationScheme(AuthenticationScheme authenticationScheme) {
        this.authenticationScheme = authenticationScheme;
        return this;
    }

    public SignedRequestScope signedRequestScope() {
        return this.signedRequestScope;
    }

    public TokenAuthConfiguration withSignedRequestScope(SignedRequestScope signedRequestScope) {
        this.signedRequestScope = signedRequestScope;
        return this;
    }

    public Boolean disableCertificateAuthenticationFallback() {
        return this.disableCertificateAuthenticationFallback;
    }

    public TokenAuthConfiguration withDisableCertificateAuthenticationFallback(Boolean disableCertificateAuthenticationFallback) {
        this.disableCertificateAuthenticationFallback = disableCertificateAuthenticationFallback;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("authenticationScheme", this.authenticationScheme == null ? null : this.authenticationScheme.toString());
        jsonWriter.writeStringField("signedRequestScope", this.signedRequestScope == null ? null : this.signedRequestScope.toString());
        jsonWriter.writeBooleanField("disableCertificateAuthenticationFallback", this.disableCertificateAuthenticationFallback);
        return jsonWriter.writeEndObject();
    }

    public static TokenAuthConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return (TokenAuthConfiguration)jsonReader.readObject(reader -> {
            TokenAuthConfiguration deserializedTokenAuthConfiguration = new TokenAuthConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("authenticationScheme".equals(fieldName)) {
                    deserializedTokenAuthConfiguration.authenticationScheme = AuthenticationScheme.fromString(reader.getString());
                    continue;
                }
                if ("signedRequestScope".equals(fieldName)) {
                    deserializedTokenAuthConfiguration.signedRequestScope = SignedRequestScope.fromString(reader.getString());
                    continue;
                }
                if ("disableCertificateAuthenticationFallback".equals(fieldName)) {
                    deserializedTokenAuthConfiguration.disableCertificateAuthenticationFallback = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedTokenAuthConfiguration;
        });
    }
}

