/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.providerhub.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.providerhub.models.ThrottlingMetric;
import java.io.IOException;
import java.util.List;

public final class ThrottlingRule
implements JsonSerializable<ThrottlingRule> {
    private String action;
    private List<ThrottlingMetric> metrics;
    private List<String> requiredFeatures;
    private List<String> applicationId;
    private static final ClientLogger LOGGER = new ClientLogger(ThrottlingRule.class);

    public String action() {
        return this.action;
    }

    public ThrottlingRule withAction(String action) {
        this.action = action;
        return this;
    }

    public List<ThrottlingMetric> metrics() {
        return this.metrics;
    }

    public ThrottlingRule withMetrics(List<ThrottlingMetric> metrics) {
        this.metrics = metrics;
        return this;
    }

    public List<String> requiredFeatures() {
        return this.requiredFeatures;
    }

    public ThrottlingRule withRequiredFeatures(List<String> requiredFeatures) {
        this.requiredFeatures = requiredFeatures;
        return this;
    }

    public List<String> applicationId() {
        return this.applicationId;
    }

    public ThrottlingRule withApplicationId(List<String> applicationId) {
        this.applicationId = applicationId;
        return this;
    }

    public void validate() {
        if (this.action() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property action in model ThrottlingRule"));
        }
        if (this.metrics() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property metrics in model ThrottlingRule"));
        }
        this.metrics().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("action", this.action);
        jsonWriter.writeArrayField("metrics", this.metrics, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("requiredFeatures", this.requiredFeatures, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("applicationId", this.applicationId, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static ThrottlingRule fromJson(JsonReader jsonReader) throws IOException {
        return (ThrottlingRule)jsonReader.readObject(reader -> {
            ThrottlingRule deserializedThrottlingRule = new ThrottlingRule();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("action".equals(fieldName)) {
                    deserializedThrottlingRule.action = reader.getString();
                    continue;
                }
                if ("metrics".equals(fieldName)) {
                    List metrics;
                    deserializedThrottlingRule.metrics = metrics = reader.readArray(reader1 -> ThrottlingMetric.fromJson(reader1));
                    continue;
                }
                if ("requiredFeatures".equals(fieldName)) {
                    List requiredFeatures;
                    deserializedThrottlingRule.requiredFeatures = requiredFeatures = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("applicationId".equals(fieldName)) {
                    List applicationId;
                    deserializedThrottlingRule.applicationId = applicationId = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedThrottlingRule;
        });
    }
}

