/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.providerhub.models;

import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.providerhub.models.ThrottlingMetricType;
import java.io.IOException;
import java.time.Duration;

public final class ThrottlingMetric
implements JsonSerializable<ThrottlingMetric> {
    private ThrottlingMetricType type;
    private long limit;
    private Duration interval;
    private static final ClientLogger LOGGER = new ClientLogger(ThrottlingMetric.class);

    public ThrottlingMetricType type() {
        return this.type;
    }

    public ThrottlingMetric withType(ThrottlingMetricType type) {
        this.type = type;
        return this;
    }

    public long limit() {
        return this.limit;
    }

    public ThrottlingMetric withLimit(long limit) {
        this.limit = limit;
        return this;
    }

    public Duration interval() {
        return this.interval;
    }

    public ThrottlingMetric withInterval(Duration interval) {
        this.interval = interval;
        return this;
    }

    public void validate() {
        if (this.type() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property type in model ThrottlingMetric"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeLongField("limit", this.limit);
        jsonWriter.writeStringField("interval", CoreUtils.durationToStringWithDays((Duration)this.interval));
        return jsonWriter.writeEndObject();
    }

    public static ThrottlingMetric fromJson(JsonReader jsonReader) throws IOException {
        return (ThrottlingMetric)jsonReader.readObject(reader -> {
            ThrottlingMetric deserializedThrottlingMetric = new ThrottlingMetric();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedThrottlingMetric.type = ThrottlingMetricType.fromString(reader.getString());
                    continue;
                }
                if ("limit".equals(fieldName)) {
                    deserializedThrottlingMetric.limit = reader.getLong();
                    continue;
                }
                if ("interval".equals(fieldName)) {
                    deserializedThrottlingMetric.interval = (Duration)reader.getNullable(nonNullReader -> Duration.parse(nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedThrottlingMetric;
        });
    }
}

