/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.providerhub.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.providerhub.models.LightHouseAuthorization;
import java.io.IOException;
import java.util.List;

public class ThirdPartyProviderAuthorization
implements JsonSerializable<ThirdPartyProviderAuthorization> {
    private List<LightHouseAuthorization> authorizations;
    private String managedByTenantId;

    public List<LightHouseAuthorization> authorizations() {
        return this.authorizations;
    }

    public ThirdPartyProviderAuthorization withAuthorizations(List<LightHouseAuthorization> authorizations) {
        this.authorizations = authorizations;
        return this;
    }

    public String managedByTenantId() {
        return this.managedByTenantId;
    }

    public ThirdPartyProviderAuthorization withManagedByTenantId(String managedByTenantId) {
        this.managedByTenantId = managedByTenantId;
        return this;
    }

    public void validate() {
        if (this.authorizations() != null) {
            this.authorizations().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("authorizations", this.authorizations, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("managedByTenantId", this.managedByTenantId);
        return jsonWriter.writeEndObject();
    }

    public static ThirdPartyProviderAuthorization fromJson(JsonReader jsonReader) throws IOException {
        return (ThirdPartyProviderAuthorization)jsonReader.readObject(reader -> {
            ThirdPartyProviderAuthorization deserializedThirdPartyProviderAuthorization = new ThirdPartyProviderAuthorization();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("authorizations".equals(fieldName)) {
                    List authorizations;
                    deserializedThirdPartyProviderAuthorization.authorizations = authorizations = reader.readArray(reader1 -> LightHouseAuthorization.fromJson(reader1));
                    continue;
                }
                if ("managedByTenantId".equals(fieldName)) {
                    deserializedThirdPartyProviderAuthorization.managedByTenantId = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedThirdPartyProviderAuthorization;
        });
    }
}

