/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.providerhub.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.providerhub.models.TemplateDeploymentCapabilities;
import com.azure.resourcemanager.providerhub.models.TemplateDeploymentPreflightNotifications;
import com.azure.resourcemanager.providerhub.models.TemplateDeploymentPreflightOptions;
import java.io.IOException;

public class TemplateDeploymentPolicy
implements JsonSerializable<TemplateDeploymentPolicy> {
    private TemplateDeploymentCapabilities capabilities;
    private TemplateDeploymentPreflightOptions preflightOptions;
    private TemplateDeploymentPreflightNotifications preflightNotifications;
    private static final ClientLogger LOGGER = new ClientLogger(TemplateDeploymentPolicy.class);

    public TemplateDeploymentCapabilities capabilities() {
        return this.capabilities;
    }

    public TemplateDeploymentPolicy withCapabilities(TemplateDeploymentCapabilities capabilities) {
        this.capabilities = capabilities;
        return this;
    }

    public TemplateDeploymentPreflightOptions preflightOptions() {
        return this.preflightOptions;
    }

    public TemplateDeploymentPolicy withPreflightOptions(TemplateDeploymentPreflightOptions preflightOptions) {
        this.preflightOptions = preflightOptions;
        return this;
    }

    public TemplateDeploymentPreflightNotifications preflightNotifications() {
        return this.preflightNotifications;
    }

    public TemplateDeploymentPolicy withPreflightNotifications(TemplateDeploymentPreflightNotifications preflightNotifications) {
        this.preflightNotifications = preflightNotifications;
        return this;
    }

    public void validate() {
        if (this.capabilities() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property capabilities in model TemplateDeploymentPolicy"));
        }
        if (this.preflightOptions() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property preflightOptions in model TemplateDeploymentPolicy"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("capabilities", this.capabilities == null ? null : this.capabilities.toString());
        jsonWriter.writeStringField("preflightOptions", this.preflightOptions == null ? null : this.preflightOptions.toString());
        jsonWriter.writeStringField("preflightNotifications", this.preflightNotifications == null ? null : this.preflightNotifications.toString());
        return jsonWriter.writeEndObject();
    }

    public static TemplateDeploymentPolicy fromJson(JsonReader jsonReader) throws IOException {
        return (TemplateDeploymentPolicy)jsonReader.readObject(reader -> {
            TemplateDeploymentPolicy deserializedTemplateDeploymentPolicy = new TemplateDeploymentPolicy();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("capabilities".equals(fieldName)) {
                    deserializedTemplateDeploymentPolicy.capabilities = TemplateDeploymentCapabilities.fromString(reader.getString());
                    continue;
                }
                if ("preflightOptions".equals(fieldName)) {
                    deserializedTemplateDeploymentPolicy.preflightOptions = TemplateDeploymentPreflightOptions.fromString(reader.getString());
                    continue;
                }
                if ("preflightNotifications".equals(fieldName)) {
                    deserializedTemplateDeploymentPolicy.preflightNotifications = TemplateDeploymentPreflightNotifications.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedTemplateDeploymentPolicy;
        });
    }
}

