/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.providerhub.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.providerhub.models.PreflightOption;
import java.io.IOException;
import java.util.List;

public class TemplateDeploymentOptions
implements JsonSerializable<TemplateDeploymentOptions> {
    private Boolean preflightSupported;
    private List<PreflightOption> preflightOptions;

    public Boolean preflightSupported() {
        return this.preflightSupported;
    }

    public TemplateDeploymentOptions withPreflightSupported(Boolean preflightSupported) {
        this.preflightSupported = preflightSupported;
        return this;
    }

    public List<PreflightOption> preflightOptions() {
        return this.preflightOptions;
    }

    public TemplateDeploymentOptions withPreflightOptions(List<PreflightOption> preflightOptions) {
        this.preflightOptions = preflightOptions;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("preflightSupported", this.preflightSupported);
        jsonWriter.writeArrayField("preflightOptions", this.preflightOptions, (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        return jsonWriter.writeEndObject();
    }

    public static TemplateDeploymentOptions fromJson(JsonReader jsonReader) throws IOException {
        return (TemplateDeploymentOptions)jsonReader.readObject(reader -> {
            TemplateDeploymentOptions deserializedTemplateDeploymentOptions = new TemplateDeploymentOptions();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("preflightSupported".equals(fieldName)) {
                    deserializedTemplateDeploymentOptions.preflightSupported = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("preflightOptions".equals(fieldName)) {
                    List preflightOptions;
                    deserializedTemplateDeploymentOptions.preflightOptions = preflightOptions = reader.readArray(reader1 -> PreflightOption.fromString(reader1.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedTemplateDeploymentOptions;
        });
    }
}

