/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.providerhub.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.providerhub.models.SubscriptionNotificationOperation;
import com.azure.resourcemanager.providerhub.models.SubscriptionTransitioningState;
import java.io.IOException;

public final class SubscriptionStateOverrideAction
implements JsonSerializable<SubscriptionStateOverrideAction> {
    private SubscriptionTransitioningState state;
    private SubscriptionNotificationOperation action;
    private static final ClientLogger LOGGER = new ClientLogger(SubscriptionStateOverrideAction.class);

    public SubscriptionTransitioningState state() {
        return this.state;
    }

    public SubscriptionStateOverrideAction withState(SubscriptionTransitioningState state) {
        this.state = state;
        return this;
    }

    public SubscriptionNotificationOperation action() {
        return this.action;
    }

    public SubscriptionStateOverrideAction withAction(SubscriptionNotificationOperation action) {
        this.action = action;
        return this;
    }

    public void validate() {
        if (this.state() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property state in model SubscriptionStateOverrideAction"));
        }
        if (this.action() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property action in model SubscriptionStateOverrideAction"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("state", this.state == null ? null : this.state.toString());
        jsonWriter.writeStringField("action", this.action == null ? null : this.action.toString());
        return jsonWriter.writeEndObject();
    }

    public static SubscriptionStateOverrideAction fromJson(JsonReader jsonReader) throws IOException {
        return (SubscriptionStateOverrideAction)jsonReader.readObject(reader -> {
            SubscriptionStateOverrideAction deserializedSubscriptionStateOverrideAction = new SubscriptionStateOverrideAction();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("state".equals(fieldName)) {
                    deserializedSubscriptionStateOverrideAction.state = SubscriptionTransitioningState.fromString(reader.getString());
                    continue;
                }
                if ("action".equals(fieldName)) {
                    deserializedSubscriptionStateOverrideAction.action = SubscriptionNotificationOperation.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSubscriptionStateOverrideAction;
        });
    }
}

