/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.providerhub.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.providerhub.models.SubscriptionStateOverrideAction;
import java.io.IOException;
import java.time.Duration;
import java.util.List;

public class SubscriptionLifecycleNotificationSpecifications
implements JsonSerializable<SubscriptionLifecycleNotificationSpecifications> {
    private List<SubscriptionStateOverrideAction> subscriptionStateOverrideActions;
    private Duration softDeleteTtl;

    public List<SubscriptionStateOverrideAction> subscriptionStateOverrideActions() {
        return this.subscriptionStateOverrideActions;
    }

    public SubscriptionLifecycleNotificationSpecifications withSubscriptionStateOverrideActions(List<SubscriptionStateOverrideAction> subscriptionStateOverrideActions) {
        this.subscriptionStateOverrideActions = subscriptionStateOverrideActions;
        return this;
    }

    public Duration softDeleteTtl() {
        return this.softDeleteTtl;
    }

    public SubscriptionLifecycleNotificationSpecifications withSoftDeleteTtl(Duration softDeleteTtl) {
        this.softDeleteTtl = softDeleteTtl;
        return this;
    }

    public void validate() {
        if (this.subscriptionStateOverrideActions() != null) {
            this.subscriptionStateOverrideActions().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("subscriptionStateOverrideActions", this.subscriptionStateOverrideActions, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("softDeleteTTL", CoreUtils.durationToStringWithDays((Duration)this.softDeleteTtl));
        return jsonWriter.writeEndObject();
    }

    public static SubscriptionLifecycleNotificationSpecifications fromJson(JsonReader jsonReader) throws IOException {
        return (SubscriptionLifecycleNotificationSpecifications)jsonReader.readObject(reader -> {
            SubscriptionLifecycleNotificationSpecifications deserializedSubscriptionLifecycleNotificationSpecifications = new SubscriptionLifecycleNotificationSpecifications();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("subscriptionStateOverrideActions".equals(fieldName)) {
                    List subscriptionStateOverrideActions;
                    deserializedSubscriptionLifecycleNotificationSpecifications.subscriptionStateOverrideActions = subscriptionStateOverrideActions = reader.readArray(reader1 -> SubscriptionStateOverrideAction.fromJson(reader1));
                    continue;
                }
                if ("softDeleteTTL".equals(fieldName)) {
                    deserializedSubscriptionLifecycleNotificationSpecifications.softDeleteTtl = (Duration)reader.getNullable(nonNullReader -> Duration.parse(nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSubscriptionLifecycleNotificationSpecifications;
        });
    }
}

