/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.providerhub.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.providerhub.models.SkuCapability;
import java.io.IOException;
import java.util.List;

public final class SkuZoneDetail
implements JsonSerializable<SkuZoneDetail> {
    private List<String> name;
    private List<SkuCapability> capabilities;

    public List<String> name() {
        return this.name;
    }

    public SkuZoneDetail withName(List<String> name) {
        this.name = name;
        return this;
    }

    public List<SkuCapability> capabilities() {
        return this.capabilities;
    }

    public SkuZoneDetail withCapabilities(List<SkuCapability> capabilities) {
        this.capabilities = capabilities;
        return this;
    }

    public void validate() {
        if (this.capabilities() != null) {
            this.capabilities().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("name", this.name, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("capabilities", this.capabilities, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static SkuZoneDetail fromJson(JsonReader jsonReader) throws IOException {
        return (SkuZoneDetail)jsonReader.readObject(reader -> {
            SkuZoneDetail deserializedSkuZoneDetail = new SkuZoneDetail();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    List name;
                    deserializedSkuZoneDetail.name = name = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("capabilities".equals(fieldName)) {
                    List capabilities;
                    deserializedSkuZoneDetail.capabilities = capabilities = reader.readArray(reader1 -> SkuCapability.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSkuZoneDetail;
        });
    }
}

