/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.providerhub.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.providerhub.models.SkuCapacity;
import com.azure.resourcemanager.providerhub.models.SkuScaleType;
import java.io.IOException;

public final class SkuSettingCapacity
extends SkuCapacity {
    @Override
    public SkuSettingCapacity withMinimum(int minimum) {
        super.withMinimum(minimum);
        return this;
    }

    @Override
    public SkuSettingCapacity withMaximum(Integer maximum) {
        super.withMaximum(maximum);
        return this;
    }

    @Override
    public SkuSettingCapacity withDefaultProperty(Integer defaultProperty) {
        super.withDefaultProperty(defaultProperty);
        return this;
    }

    @Override
    public SkuSettingCapacity withScaleType(SkuScaleType scaleType) {
        super.withScaleType(scaleType);
        return this;
    }

    @Override
    public void validate() {
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeIntField("minimum", this.minimum());
        jsonWriter.writeNumberField("maximum", (Number)this.maximum());
        jsonWriter.writeNumberField("default", (Number)this.defaultProperty());
        jsonWriter.writeStringField("scaleType", this.scaleType() == null ? null : this.scaleType().toString());
        return jsonWriter.writeEndObject();
    }

    public static SkuSettingCapacity fromJson(JsonReader jsonReader) throws IOException {
        return (SkuSettingCapacity)jsonReader.readObject(reader -> {
            SkuSettingCapacity deserializedSkuSettingCapacity = new SkuSettingCapacity();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("minimum".equals(fieldName)) {
                    deserializedSkuSettingCapacity.withMinimum(reader.getInt());
                    continue;
                }
                if ("maximum".equals(fieldName)) {
                    deserializedSkuSettingCapacity.withMaximum((Integer)reader.getNullable(JsonReader::getInt));
                    continue;
                }
                if ("default".equals(fieldName)) {
                    deserializedSkuSettingCapacity.withDefaultProperty((Integer)reader.getNullable(JsonReader::getInt));
                    continue;
                }
                if ("scaleType".equals(fieldName)) {
                    deserializedSkuSettingCapacity.withScaleType(SkuScaleType.fromString(reader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSkuSettingCapacity;
        });
    }
}

