/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.providerhub.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.providerhub.models.SkuCapability;
import com.azure.resourcemanager.providerhub.models.SkuCost;
import com.azure.resourcemanager.providerhub.models.SkuLocationInfo;
import com.azure.resourcemanager.providerhub.models.SkuSettingCapacity;
import java.io.IOException;
import java.util.List;

public final class SkuSetting
implements JsonSerializable<SkuSetting> {
    private String name;
    private String tier;
    private String size;
    private String family;
    private String kind;
    private List<String> locations;
    private List<SkuLocationInfo> locationInfo;
    private List<String> requiredQuotaIds;
    private List<String> requiredFeatures;
    private SkuSettingCapacity capacity;
    private List<SkuCost> costs;
    private List<SkuCapability> capabilities;
    private static final ClientLogger LOGGER = new ClientLogger(SkuSetting.class);

    public String name() {
        return this.name;
    }

    public SkuSetting withName(String name) {
        this.name = name;
        return this;
    }

    public String tier() {
        return this.tier;
    }

    public SkuSetting withTier(String tier) {
        this.tier = tier;
        return this;
    }

    public String size() {
        return this.size;
    }

    public SkuSetting withSize(String size) {
        this.size = size;
        return this;
    }

    public String family() {
        return this.family;
    }

    public SkuSetting withFamily(String family) {
        this.family = family;
        return this;
    }

    public String kind() {
        return this.kind;
    }

    public SkuSetting withKind(String kind) {
        this.kind = kind;
        return this;
    }

    public List<String> locations() {
        return this.locations;
    }

    public SkuSetting withLocations(List<String> locations) {
        this.locations = locations;
        return this;
    }

    public List<SkuLocationInfo> locationInfo() {
        return this.locationInfo;
    }

    public SkuSetting withLocationInfo(List<SkuLocationInfo> locationInfo) {
        this.locationInfo = locationInfo;
        return this;
    }

    public List<String> requiredQuotaIds() {
        return this.requiredQuotaIds;
    }

    public SkuSetting withRequiredQuotaIds(List<String> requiredQuotaIds) {
        this.requiredQuotaIds = requiredQuotaIds;
        return this;
    }

    public List<String> requiredFeatures() {
        return this.requiredFeatures;
    }

    public SkuSetting withRequiredFeatures(List<String> requiredFeatures) {
        this.requiredFeatures = requiredFeatures;
        return this;
    }

    public SkuSettingCapacity capacity() {
        return this.capacity;
    }

    public SkuSetting withCapacity(SkuSettingCapacity capacity) {
        this.capacity = capacity;
        return this;
    }

    public List<SkuCost> costs() {
        return this.costs;
    }

    public SkuSetting withCosts(List<SkuCost> costs) {
        this.costs = costs;
        return this;
    }

    public List<SkuCapability> capabilities() {
        return this.capabilities;
    }

    public SkuSetting withCapabilities(List<SkuCapability> capabilities) {
        this.capabilities = capabilities;
        return this;
    }

    public void validate() {
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model SkuSetting"));
        }
        if (this.locationInfo() != null) {
            this.locationInfo().forEach(e -> e.validate());
        }
        if (this.capacity() != null) {
            this.capacity().validate();
        }
        if (this.costs() != null) {
            this.costs().forEach(e -> e.validate());
        }
        if (this.capabilities() != null) {
            this.capabilities().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("tier", this.tier);
        jsonWriter.writeStringField("size", this.size);
        jsonWriter.writeStringField("family", this.family);
        jsonWriter.writeStringField("kind", this.kind);
        jsonWriter.writeArrayField("locations", this.locations, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("locationInfo", this.locationInfo, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("requiredQuotaIds", this.requiredQuotaIds, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("requiredFeatures", this.requiredFeatures, (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("capacity", (JsonSerializable)this.capacity);
        jsonWriter.writeArrayField("costs", this.costs, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("capabilities", this.capabilities, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static SkuSetting fromJson(JsonReader jsonReader) throws IOException {
        return (SkuSetting)jsonReader.readObject(reader -> {
            SkuSetting deserializedSkuSetting = new SkuSetting();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedSkuSetting.name = reader.getString();
                    continue;
                }
                if ("tier".equals(fieldName)) {
                    deserializedSkuSetting.tier = reader.getString();
                    continue;
                }
                if ("size".equals(fieldName)) {
                    deserializedSkuSetting.size = reader.getString();
                    continue;
                }
                if ("family".equals(fieldName)) {
                    deserializedSkuSetting.family = reader.getString();
                    continue;
                }
                if ("kind".equals(fieldName)) {
                    deserializedSkuSetting.kind = reader.getString();
                    continue;
                }
                if ("locations".equals(fieldName)) {
                    List locations;
                    deserializedSkuSetting.locations = locations = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("locationInfo".equals(fieldName)) {
                    List locationInfo;
                    deserializedSkuSetting.locationInfo = locationInfo = reader.readArray(reader1 -> SkuLocationInfo.fromJson(reader1));
                    continue;
                }
                if ("requiredQuotaIds".equals(fieldName)) {
                    List requiredQuotaIds;
                    deserializedSkuSetting.requiredQuotaIds = requiredQuotaIds = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("requiredFeatures".equals(fieldName)) {
                    List requiredFeatures;
                    deserializedSkuSetting.requiredFeatures = requiredFeatures = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("capacity".equals(fieldName)) {
                    deserializedSkuSetting.capacity = SkuSettingCapacity.fromJson(reader);
                    continue;
                }
                if ("costs".equals(fieldName)) {
                    List costs;
                    deserializedSkuSetting.costs = costs = reader.readArray(reader1 -> SkuCost.fromJson(reader1));
                    continue;
                }
                if ("capabilities".equals(fieldName)) {
                    List capabilities;
                    deserializedSkuSetting.capabilities = capabilities = reader.readArray(reader1 -> SkuCapability.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSkuSetting;
        });
    }
}

