/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.providerhub.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.providerhub.models.ProvisioningState;
import com.azure.resourcemanager.providerhub.models.ResourceTypeSku;
import com.azure.resourcemanager.providerhub.models.SkuSetting;
import java.io.IOException;
import java.util.List;

public final class SkuResourceProperties
extends ResourceTypeSku {
    private ProvisioningState provisioningState;
    private static final ClientLogger LOGGER = new ClientLogger(SkuResourceProperties.class);

    @Override
    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    @Override
    public SkuResourceProperties withSkuSettings(List<SkuSetting> skuSettings) {
        super.withSkuSettings(skuSettings);
        return this;
    }

    @Override
    public void validate() {
        if (this.skuSettings() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property skuSettings in model SkuResourceProperties"));
        }
        this.skuSettings().forEach(e -> e.validate());
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("skuSettings", this.skuSettings(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static SkuResourceProperties fromJson(JsonReader jsonReader) throws IOException {
        return (SkuResourceProperties)jsonReader.readObject(reader -> {
            SkuResourceProperties deserializedSkuResourceProperties = new SkuResourceProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("skuSettings".equals(fieldName)) {
                    List skuSettings = reader.readArray(reader1 -> SkuSetting.fromJson(reader1));
                    deserializedSkuResourceProperties.withSkuSettings(skuSettings);
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedSkuResourceProperties.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSkuResourceProperties;
        });
    }
}

