/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.providerhub.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.providerhub.models.ExtendedLocationType;
import com.azure.resourcemanager.providerhub.models.SkuZoneDetail;
import java.io.IOException;
import java.util.List;

public final class SkuLocationInfo
implements JsonSerializable<SkuLocationInfo> {
    private String location;
    private List<String> zones;
    private List<SkuZoneDetail> zoneDetails;
    private List<String> extendedLocations;
    private ExtendedLocationType type;
    private static final ClientLogger LOGGER = new ClientLogger(SkuLocationInfo.class);

    public String location() {
        return this.location;
    }

    public SkuLocationInfo withLocation(String location) {
        this.location = location;
        return this;
    }

    public List<String> zones() {
        return this.zones;
    }

    public SkuLocationInfo withZones(List<String> zones) {
        this.zones = zones;
        return this;
    }

    public List<SkuZoneDetail> zoneDetails() {
        return this.zoneDetails;
    }

    public SkuLocationInfo withZoneDetails(List<SkuZoneDetail> zoneDetails) {
        this.zoneDetails = zoneDetails;
        return this;
    }

    public List<String> extendedLocations() {
        return this.extendedLocations;
    }

    public SkuLocationInfo withExtendedLocations(List<String> extendedLocations) {
        this.extendedLocations = extendedLocations;
        return this;
    }

    public ExtendedLocationType type() {
        return this.type;
    }

    public SkuLocationInfo withType(ExtendedLocationType type) {
        this.type = type;
        return this;
    }

    public void validate() {
        if (this.location() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property location in model SkuLocationInfo"));
        }
        if (this.zoneDetails() != null) {
            this.zoneDetails().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location);
        jsonWriter.writeArrayField("zones", this.zones, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("zoneDetails", this.zoneDetails, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("extendedLocations", this.extendedLocations, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    public static SkuLocationInfo fromJson(JsonReader jsonReader) throws IOException {
        return (SkuLocationInfo)jsonReader.readObject(reader -> {
            SkuLocationInfo deserializedSkuLocationInfo = new SkuLocationInfo();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("location".equals(fieldName)) {
                    deserializedSkuLocationInfo.location = reader.getString();
                    continue;
                }
                if ("zones".equals(fieldName)) {
                    List zones;
                    deserializedSkuLocationInfo.zones = zones = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("zoneDetails".equals(fieldName)) {
                    List zoneDetails;
                    deserializedSkuLocationInfo.zoneDetails = zoneDetails = reader.readArray(reader1 -> SkuZoneDetail.fromJson(reader1));
                    continue;
                }
                if ("extendedLocations".equals(fieldName)) {
                    List extendedLocations;
                    deserializedSkuLocationInfo.extendedLocations = extendedLocations = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedSkuLocationInfo.type = ExtendedLocationType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSkuLocationInfo;
        });
    }
}

