/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.providerhub.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class SkuCost
implements JsonSerializable<SkuCost> {
    private String meterId;
    private Integer quantity;
    private String extendedUnit;
    private static final ClientLogger LOGGER = new ClientLogger(SkuCost.class);

    public String meterId() {
        return this.meterId;
    }

    public SkuCost withMeterId(String meterId) {
        this.meterId = meterId;
        return this;
    }

    public Integer quantity() {
        return this.quantity;
    }

    public SkuCost withQuantity(Integer quantity) {
        this.quantity = quantity;
        return this;
    }

    public String extendedUnit() {
        return this.extendedUnit;
    }

    public SkuCost withExtendedUnit(String extendedUnit) {
        this.extendedUnit = extendedUnit;
        return this;
    }

    public void validate() {
        if (this.meterId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property meterId in model SkuCost"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("meterId", this.meterId);
        jsonWriter.writeNumberField("quantity", (Number)this.quantity);
        jsonWriter.writeStringField("extendedUnit", this.extendedUnit);
        return jsonWriter.writeEndObject();
    }

    public static SkuCost fromJson(JsonReader jsonReader) throws IOException {
        return (SkuCost)jsonReader.readObject(reader -> {
            SkuCost deserializedSkuCost = new SkuCost();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("meterId".equals(fieldName)) {
                    deserializedSkuCost.meterId = reader.getString();
                    continue;
                }
                if ("quantity".equals(fieldName)) {
                    deserializedSkuCost.quantity = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("extendedUnit".equals(fieldName)) {
                    deserializedSkuCost.extendedUnit = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSkuCost;
        });
    }
}

