/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.providerhub.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.providerhub.models.Readiness;
import java.io.IOException;

public final class ServiceTreeInfo
implements JsonSerializable<ServiceTreeInfo> {
    private String serviceId;
    private String componentId;
    private Readiness readiness;

    public String serviceId() {
        return this.serviceId;
    }

    public ServiceTreeInfo withServiceId(String serviceId) {
        this.serviceId = serviceId;
        return this;
    }

    public String componentId() {
        return this.componentId;
    }

    public ServiceTreeInfo withComponentId(String componentId) {
        this.componentId = componentId;
        return this;
    }

    public Readiness readiness() {
        return this.readiness;
    }

    public ServiceTreeInfo withReadiness(Readiness readiness) {
        this.readiness = readiness;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("serviceId", this.serviceId);
        jsonWriter.writeStringField("componentId", this.componentId);
        jsonWriter.writeStringField("readiness", this.readiness == null ? null : this.readiness.toString());
        return jsonWriter.writeEndObject();
    }

    public static ServiceTreeInfo fromJson(JsonReader jsonReader) throws IOException {
        return (ServiceTreeInfo)jsonReader.readObject(reader -> {
            ServiceTreeInfo deserializedServiceTreeInfo = new ServiceTreeInfo();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("serviceId".equals(fieldName)) {
                    deserializedServiceTreeInfo.serviceId = reader.getString();
                    continue;
                }
                if ("componentId".equals(fieldName)) {
                    deserializedServiceTreeInfo.componentId = reader.getString();
                    continue;
                }
                if ("readiness".equals(fieldName)) {
                    deserializedServiceTreeInfo.readiness = Readiness.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedServiceTreeInfo;
        });
    }
}

