/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.providerhub.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.providerhub.models.ExtendedErrorInfo;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class RolloutStatusBase
implements JsonSerializable<RolloutStatusBase> {
    private List<String> completedRegions;
    private Map<String, ExtendedErrorInfo> failedOrSkippedRegions;

    public List<String> completedRegions() {
        return this.completedRegions;
    }

    public RolloutStatusBase withCompletedRegions(List<String> completedRegions) {
        this.completedRegions = completedRegions;
        return this;
    }

    public Map<String, ExtendedErrorInfo> failedOrSkippedRegions() {
        return this.failedOrSkippedRegions;
    }

    public RolloutStatusBase withFailedOrSkippedRegions(Map<String, ExtendedErrorInfo> failedOrSkippedRegions) {
        this.failedOrSkippedRegions = failedOrSkippedRegions;
        return this;
    }

    public void validate() {
        if (this.failedOrSkippedRegions() != null) {
            this.failedOrSkippedRegions().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("completedRegions", this.completedRegions, (writer, element) -> writer.writeString(element));
        jsonWriter.writeMapField("failedOrSkippedRegions", this.failedOrSkippedRegions, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static RolloutStatusBase fromJson(JsonReader jsonReader) throws IOException {
        return (RolloutStatusBase)jsonReader.readObject(reader -> {
            RolloutStatusBase deserializedRolloutStatusBase = new RolloutStatusBase();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("completedRegions".equals(fieldName)) {
                    List completedRegions;
                    deserializedRolloutStatusBase.completedRegions = completedRegions = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("failedOrSkippedRegions".equals(fieldName)) {
                    Map failedOrSkippedRegions;
                    deserializedRolloutStatusBase.failedOrSkippedRegions = failedOrSkippedRegions = reader.readMap(reader1 -> ExtendedErrorInfo.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRolloutStatusBase;
        });
    }
}

