/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.providerhub.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.providerhub.models.ProvisioningState;
import com.azure.resourcemanager.providerhub.models.SkuSetting;
import java.io.IOException;
import java.util.List;

public class ResourceTypeSku
implements JsonSerializable<ResourceTypeSku> {
    private List<SkuSetting> skuSettings;
    private ProvisioningState provisioningState;
    private static final ClientLogger LOGGER = new ClientLogger(ResourceTypeSku.class);

    public List<SkuSetting> skuSettings() {
        return this.skuSettings;
    }

    public ResourceTypeSku withSkuSettings(List<SkuSetting> skuSettings) {
        this.skuSettings = skuSettings;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    ResourceTypeSku withProvisioningState(ProvisioningState provisioningState) {
        this.provisioningState = provisioningState;
        return this;
    }

    public void validate() {
        if (this.skuSettings() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property skuSettings in model ResourceTypeSku"));
        }
        this.skuSettings().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("skuSettings", this.skuSettings, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static ResourceTypeSku fromJson(JsonReader jsonReader) throws IOException {
        return (ResourceTypeSku)jsonReader.readObject(reader -> {
            ResourceTypeSku deserializedResourceTypeSku = new ResourceTypeSku();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("skuSettings".equals(fieldName)) {
                    List skuSettings;
                    deserializedResourceTypeSku.skuSettings = skuSettings = reader.readArray(reader1 -> SkuSetting.fromJson(reader1));
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedResourceTypeSku.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedResourceTypeSku;
        });
    }
}

