/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.providerhub.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.providerhub.models.TemplateDeploymentCapabilities;
import com.azure.resourcemanager.providerhub.models.TemplateDeploymentPolicy;
import com.azure.resourcemanager.providerhub.models.TemplateDeploymentPreflightNotifications;
import com.azure.resourcemanager.providerhub.models.TemplateDeploymentPreflightOptions;
import java.io.IOException;

public final class ResourceTypeRegistrationPropertiesTemplateDeploymentPolicy
extends TemplateDeploymentPolicy {
    private static final ClientLogger LOGGER = new ClientLogger(ResourceTypeRegistrationPropertiesTemplateDeploymentPolicy.class);

    @Override
    public ResourceTypeRegistrationPropertiesTemplateDeploymentPolicy withCapabilities(TemplateDeploymentCapabilities capabilities) {
        super.withCapabilities(capabilities);
        return this;
    }

    @Override
    public ResourceTypeRegistrationPropertiesTemplateDeploymentPolicy withPreflightOptions(TemplateDeploymentPreflightOptions preflightOptions) {
        super.withPreflightOptions(preflightOptions);
        return this;
    }

    @Override
    public ResourceTypeRegistrationPropertiesTemplateDeploymentPolicy withPreflightNotifications(TemplateDeploymentPreflightNotifications preflightNotifications) {
        super.withPreflightNotifications(preflightNotifications);
        return this;
    }

    @Override
    public void validate() {
        if (this.capabilities() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property capabilities in model ResourceTypeRegistrationPropertiesTemplateDeploymentPolicy"));
        }
        if (this.preflightOptions() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property preflightOptions in model ResourceTypeRegistrationPropertiesTemplateDeploymentPolicy"));
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("capabilities", this.capabilities() == null ? null : this.capabilities().toString());
        jsonWriter.writeStringField("preflightOptions", this.preflightOptions() == null ? null : this.preflightOptions().toString());
        jsonWriter.writeStringField("preflightNotifications", this.preflightNotifications() == null ? null : this.preflightNotifications().toString());
        return jsonWriter.writeEndObject();
    }

    public static ResourceTypeRegistrationPropertiesTemplateDeploymentPolicy fromJson(JsonReader jsonReader) throws IOException {
        return (ResourceTypeRegistrationPropertiesTemplateDeploymentPolicy)jsonReader.readObject(reader -> {
            ResourceTypeRegistrationPropertiesTemplateDeploymentPolicy deserializedResourceTypeRegistrationPropertiesTemplateDeploymentPolicy = new ResourceTypeRegistrationPropertiesTemplateDeploymentPolicy();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("capabilities".equals(fieldName)) {
                    deserializedResourceTypeRegistrationPropertiesTemplateDeploymentPolicy.withCapabilities(TemplateDeploymentCapabilities.fromString(reader.getString()));
                    continue;
                }
                if ("preflightOptions".equals(fieldName)) {
                    deserializedResourceTypeRegistrationPropertiesTemplateDeploymentPolicy.withPreflightOptions(TemplateDeploymentPreflightOptions.fromString(reader.getString()));
                    continue;
                }
                if ("preflightNotifications".equals(fieldName)) {
                    deserializedResourceTypeRegistrationPropertiesTemplateDeploymentPolicy.withPreflightNotifications(TemplateDeploymentPreflightNotifications.fromString(reader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedResourceTypeRegistrationPropertiesTemplateDeploymentPolicy;
        });
    }
}

