/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.providerhub.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.providerhub.models.IdentityManagementProperties;
import com.azure.resourcemanager.providerhub.models.IdentityManagementTypes;
import java.io.IOException;
import java.util.List;

public final class ResourceTypeRegistrationPropertiesIdentityManagement
extends IdentityManagementProperties {
    @Override
    public ResourceTypeRegistrationPropertiesIdentityManagement withType(IdentityManagementTypes type) {
        super.withType(type);
        return this;
    }

    @Override
    public ResourceTypeRegistrationPropertiesIdentityManagement withApplicationId(String applicationId) {
        super.withApplicationId(applicationId);
        return this;
    }

    @Override
    public ResourceTypeRegistrationPropertiesIdentityManagement withApplicationIds(List<String> applicationIds) {
        super.withApplicationIds(applicationIds);
        return this;
    }

    @Override
    public ResourceTypeRegistrationPropertiesIdentityManagement withDelegationAppIds(List<String> delegationAppIds) {
        super.withDelegationAppIds(delegationAppIds);
        return this;
    }

    @Override
    public void validate() {
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type() == null ? null : this.type().toString());
        jsonWriter.writeStringField("applicationId", this.applicationId());
        jsonWriter.writeArrayField("applicationIds", this.applicationIds(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("delegationAppIds", this.delegationAppIds(), (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static ResourceTypeRegistrationPropertiesIdentityManagement fromJson(JsonReader jsonReader) throws IOException {
        return (ResourceTypeRegistrationPropertiesIdentityManagement)jsonReader.readObject(reader -> {
            ResourceTypeRegistrationPropertiesIdentityManagement deserializedResourceTypeRegistrationPropertiesIdentityManagement = new ResourceTypeRegistrationPropertiesIdentityManagement();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedResourceTypeRegistrationPropertiesIdentityManagement.withType(IdentityManagementTypes.fromString(reader.getString()));
                    continue;
                }
                if ("applicationId".equals(fieldName)) {
                    deserializedResourceTypeRegistrationPropertiesIdentityManagement.withApplicationId(reader.getString());
                    continue;
                }
                if ("applicationIds".equals(fieldName)) {
                    List applicationIds = reader.readArray(reader1 -> reader1.getString());
                    deserializedResourceTypeRegistrationPropertiesIdentityManagement.withApplicationIds(applicationIds);
                    continue;
                }
                if ("delegationAppIds".equals(fieldName)) {
                    List delegationAppIds = reader.readArray(reader1 -> reader1.getString());
                    deserializedResourceTypeRegistrationPropertiesIdentityManagement.withDelegationAppIds(delegationAppIds);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedResourceTypeRegistrationPropertiesIdentityManagement;
        });
    }
}

