/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.providerhub.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.providerhub.models.ExtensionCategory;
import java.io.IOException;
import java.time.Duration;
import java.util.List;

public final class ResourceTypeExtension
implements JsonSerializable<ResourceTypeExtension> {
    private String endpointUri;
    private List<ExtensionCategory> extensionCategories;
    private Duration timeout;

    public String endpointUri() {
        return this.endpointUri;
    }

    public ResourceTypeExtension withEndpointUri(String endpointUri) {
        this.endpointUri = endpointUri;
        return this;
    }

    public List<ExtensionCategory> extensionCategories() {
        return this.extensionCategories;
    }

    public ResourceTypeExtension withExtensionCategories(List<ExtensionCategory> extensionCategories) {
        this.extensionCategories = extensionCategories;
        return this;
    }

    public Duration timeout() {
        return this.timeout;
    }

    public ResourceTypeExtension withTimeout(Duration timeout) {
        this.timeout = timeout;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("endpointUri", this.endpointUri);
        jsonWriter.writeArrayField("extensionCategories", this.extensionCategories, (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        jsonWriter.writeStringField("timeout", CoreUtils.durationToStringWithDays((Duration)this.timeout));
        return jsonWriter.writeEndObject();
    }

    public static ResourceTypeExtension fromJson(JsonReader jsonReader) throws IOException {
        return (ResourceTypeExtension)jsonReader.readObject(reader -> {
            ResourceTypeExtension deserializedResourceTypeExtension = new ResourceTypeExtension();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("endpointUri".equals(fieldName)) {
                    deserializedResourceTypeExtension.endpointUri = reader.getString();
                    continue;
                }
                if ("extensionCategories".equals(fieldName)) {
                    List extensionCategories;
                    deserializedResourceTypeExtension.extensionCategories = extensionCategories = reader.readArray(reader1 -> ExtensionCategory.fromString(reader1.getString()));
                    continue;
                }
                if ("timeout".equals(fieldName)) {
                    deserializedResourceTypeExtension.timeout = (Duration)reader.getNullable(nonNullReader -> Duration.parse(nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedResourceTypeExtension;
        });
    }
}

