/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.providerhub.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.providerhub.models.DstsConfiguration;
import java.io.IOException;

public final class ResourceTypeEndpointDstsConfiguration
extends DstsConfiguration {
    private static final ClientLogger LOGGER = new ClientLogger(ResourceTypeEndpointDstsConfiguration.class);

    @Override
    public ResourceTypeEndpointDstsConfiguration withServiceName(String serviceName) {
        super.withServiceName(serviceName);
        return this;
    }

    @Override
    public ResourceTypeEndpointDstsConfiguration withServiceDnsName(String serviceDnsName) {
        super.withServiceDnsName(serviceDnsName);
        return this;
    }

    @Override
    public void validate() {
        if (this.serviceName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property serviceName in model ResourceTypeEndpointDstsConfiguration"));
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("serviceName", this.serviceName());
        jsonWriter.writeStringField("serviceDnsName", this.serviceDnsName());
        return jsonWriter.writeEndObject();
    }

    public static ResourceTypeEndpointDstsConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return (ResourceTypeEndpointDstsConfiguration)jsonReader.readObject(reader -> {
            ResourceTypeEndpointDstsConfiguration deserializedResourceTypeEndpointDstsConfiguration = new ResourceTypeEndpointDstsConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("serviceName".equals(fieldName)) {
                    deserializedResourceTypeEndpointDstsConfiguration.withServiceName(reader.getString());
                    continue;
                }
                if ("serviceDnsName".equals(fieldName)) {
                    deserializedResourceTypeEndpointDstsConfiguration.withServiceDnsName(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedResourceTypeEndpointDstsConfiguration;
        });
    }
}

