/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.providerhub.models;

import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.providerhub.models.EndpointType;
import com.azure.resourcemanager.providerhub.models.ResourceTypeEndpointBaseDstsConfiguration;
import com.azure.resourcemanager.providerhub.models.ResourceTypeEndpointBaseFeaturesRule;
import java.io.IOException;
import java.time.Duration;
import java.util.List;

public class ResourceTypeEndpointBase
implements JsonSerializable<ResourceTypeEndpointBase> {
    private boolean enabled;
    private List<String> apiVersions;
    private String endpointUri;
    private List<String> locations;
    private List<String> requiredFeatures;
    private ResourceTypeEndpointBaseFeaturesRule featuresRule;
    private Duration timeout;
    private EndpointType endpointType;
    private ResourceTypeEndpointBaseDstsConfiguration dstsConfiguration;
    private String skuLink;
    private String apiVersion;
    private List<String> zones;
    private static final ClientLogger LOGGER = new ClientLogger(ResourceTypeEndpointBase.class);

    public boolean enabled() {
        return this.enabled;
    }

    public ResourceTypeEndpointBase withEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public List<String> apiVersions() {
        return this.apiVersions;
    }

    public ResourceTypeEndpointBase withApiVersions(List<String> apiVersions) {
        this.apiVersions = apiVersions;
        return this;
    }

    public String endpointUri() {
        return this.endpointUri;
    }

    public ResourceTypeEndpointBase withEndpointUri(String endpointUri) {
        this.endpointUri = endpointUri;
        return this;
    }

    public List<String> locations() {
        return this.locations;
    }

    public ResourceTypeEndpointBase withLocations(List<String> locations) {
        this.locations = locations;
        return this;
    }

    public List<String> requiredFeatures() {
        return this.requiredFeatures;
    }

    public ResourceTypeEndpointBase withRequiredFeatures(List<String> requiredFeatures) {
        this.requiredFeatures = requiredFeatures;
        return this;
    }

    public ResourceTypeEndpointBaseFeaturesRule featuresRule() {
        return this.featuresRule;
    }

    public ResourceTypeEndpointBase withFeaturesRule(ResourceTypeEndpointBaseFeaturesRule featuresRule) {
        this.featuresRule = featuresRule;
        return this;
    }

    public Duration timeout() {
        return this.timeout;
    }

    public ResourceTypeEndpointBase withTimeout(Duration timeout) {
        this.timeout = timeout;
        return this;
    }

    public EndpointType endpointType() {
        return this.endpointType;
    }

    public ResourceTypeEndpointBase withEndpointType(EndpointType endpointType) {
        this.endpointType = endpointType;
        return this;
    }

    public ResourceTypeEndpointBaseDstsConfiguration dstsConfiguration() {
        return this.dstsConfiguration;
    }

    public ResourceTypeEndpointBase withDstsConfiguration(ResourceTypeEndpointBaseDstsConfiguration dstsConfiguration) {
        this.dstsConfiguration = dstsConfiguration;
        return this;
    }

    public String skuLink() {
        return this.skuLink;
    }

    public ResourceTypeEndpointBase withSkuLink(String skuLink) {
        this.skuLink = skuLink;
        return this;
    }

    public String apiVersion() {
        return this.apiVersion;
    }

    public ResourceTypeEndpointBase withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    public List<String> zones() {
        return this.zones;
    }

    public ResourceTypeEndpointBase withZones(List<String> zones) {
        this.zones = zones;
        return this;
    }

    public void validate() {
        if (this.apiVersions() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property apiVersions in model ResourceTypeEndpointBase"));
        }
        if (this.endpointUri() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property endpointUri in model ResourceTypeEndpointBase"));
        }
        if (this.locations() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property locations in model ResourceTypeEndpointBase"));
        }
        if (this.requiredFeatures() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property requiredFeatures in model ResourceTypeEndpointBase"));
        }
        if (this.featuresRule() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property featuresRule in model ResourceTypeEndpointBase"));
        }
        this.featuresRule().validate();
        if (this.timeout() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property timeout in model ResourceTypeEndpointBase"));
        }
        if (this.endpointType() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property endpointType in model ResourceTypeEndpointBase"));
        }
        if (this.dstsConfiguration() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property dstsConfiguration in model ResourceTypeEndpointBase"));
        }
        this.dstsConfiguration().validate();
        if (this.skuLink() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property skuLink in model ResourceTypeEndpointBase"));
        }
        if (this.apiVersion() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property apiVersion in model ResourceTypeEndpointBase"));
        }
        if (this.zones() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property zones in model ResourceTypeEndpointBase"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("enabled", this.enabled);
        jsonWriter.writeArrayField("apiVersions", this.apiVersions, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("endpointUri", this.endpointUri);
        jsonWriter.writeArrayField("locations", this.locations, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("requiredFeatures", this.requiredFeatures, (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("featuresRule", (JsonSerializable)this.featuresRule);
        jsonWriter.writeStringField("timeout", CoreUtils.durationToStringWithDays((Duration)this.timeout));
        jsonWriter.writeStringField("endpointType", this.endpointType == null ? null : this.endpointType.toString());
        jsonWriter.writeJsonField("dstsConfiguration", (JsonSerializable)this.dstsConfiguration);
        jsonWriter.writeStringField("skuLink", this.skuLink);
        jsonWriter.writeStringField("apiVersion", this.apiVersion);
        jsonWriter.writeArrayField("zones", this.zones, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static ResourceTypeEndpointBase fromJson(JsonReader jsonReader) throws IOException {
        return (ResourceTypeEndpointBase)jsonReader.readObject(reader -> {
            ResourceTypeEndpointBase deserializedResourceTypeEndpointBase = new ResourceTypeEndpointBase();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("enabled".equals(fieldName)) {
                    deserializedResourceTypeEndpointBase.enabled = reader.getBoolean();
                    continue;
                }
                if ("apiVersions".equals(fieldName)) {
                    List apiVersions;
                    deserializedResourceTypeEndpointBase.apiVersions = apiVersions = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("endpointUri".equals(fieldName)) {
                    deserializedResourceTypeEndpointBase.endpointUri = reader.getString();
                    continue;
                }
                if ("locations".equals(fieldName)) {
                    List locations;
                    deserializedResourceTypeEndpointBase.locations = locations = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("requiredFeatures".equals(fieldName)) {
                    List requiredFeatures;
                    deserializedResourceTypeEndpointBase.requiredFeatures = requiredFeatures = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("featuresRule".equals(fieldName)) {
                    deserializedResourceTypeEndpointBase.featuresRule = ResourceTypeEndpointBaseFeaturesRule.fromJson(reader);
                    continue;
                }
                if ("timeout".equals(fieldName)) {
                    deserializedResourceTypeEndpointBase.timeout = (Duration)reader.getNullable(nonNullReader -> Duration.parse(nonNullReader.getString()));
                    continue;
                }
                if ("endpointType".equals(fieldName)) {
                    deserializedResourceTypeEndpointBase.endpointType = EndpointType.fromString(reader.getString());
                    continue;
                }
                if ("dstsConfiguration".equals(fieldName)) {
                    deserializedResourceTypeEndpointBase.dstsConfiguration = ResourceTypeEndpointBaseDstsConfiguration.fromJson(reader);
                    continue;
                }
                if ("skuLink".equals(fieldName)) {
                    deserializedResourceTypeEndpointBase.skuLink = reader.getString();
                    continue;
                }
                if ("apiVersion".equals(fieldName)) {
                    deserializedResourceTypeEndpointBase.apiVersion = reader.getString();
                    continue;
                }
                if ("zones".equals(fieldName)) {
                    List zones;
                    deserializedResourceTypeEndpointBase.zones = zones = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedResourceTypeEndpointBase;
        });
    }
}

