/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.providerhub.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.providerhub.models.DataBoundary;
import com.azure.resourcemanager.providerhub.models.EndpointTypeResourceType;
import com.azure.resourcemanager.providerhub.models.ResourceTypeEndpointDstsConfiguration;
import com.azure.resourcemanager.providerhub.models.ResourceTypeEndpointFeaturesRule;
import com.azure.resourcemanager.providerhub.models.ResourceTypeEndpointKind;
import com.azure.resourcemanager.providerhub.models.ResourceTypeExtension;
import com.azure.resourcemanager.providerhub.models.TokenAuthConfiguration;
import java.io.IOException;
import java.time.Duration;
import java.util.List;

public final class ResourceTypeEndpoint
implements JsonSerializable<ResourceTypeEndpoint> {
    private ResourceTypeEndpointKind kind;
    private Boolean enabled;
    private List<String> apiVersions;
    private List<String> locations;
    private List<String> requiredFeatures;
    private ResourceTypeEndpointFeaturesRule featuresRule;
    private List<ResourceTypeExtension> extensions;
    private Duration timeout;
    private EndpointTypeResourceType endpointType;
    private TokenAuthConfiguration tokenAuthConfiguration;
    private String skuLink;
    private String endpointUri;
    private String apiVersion;
    private List<String> zones;
    private ResourceTypeEndpointDstsConfiguration dstsConfiguration;
    private DataBoundary dataBoundary;

    public ResourceTypeEndpointKind kind() {
        return this.kind;
    }

    public ResourceTypeEndpoint withKind(ResourceTypeEndpointKind kind) {
        this.kind = kind;
        return this;
    }

    public Boolean enabled() {
        return this.enabled;
    }

    public ResourceTypeEndpoint withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public List<String> apiVersions() {
        return this.apiVersions;
    }

    public ResourceTypeEndpoint withApiVersions(List<String> apiVersions) {
        this.apiVersions = apiVersions;
        return this;
    }

    public List<String> locations() {
        return this.locations;
    }

    public ResourceTypeEndpoint withLocations(List<String> locations) {
        this.locations = locations;
        return this;
    }

    public List<String> requiredFeatures() {
        return this.requiredFeatures;
    }

    public ResourceTypeEndpoint withRequiredFeatures(List<String> requiredFeatures) {
        this.requiredFeatures = requiredFeatures;
        return this;
    }

    public ResourceTypeEndpointFeaturesRule featuresRule() {
        return this.featuresRule;
    }

    public ResourceTypeEndpoint withFeaturesRule(ResourceTypeEndpointFeaturesRule featuresRule) {
        this.featuresRule = featuresRule;
        return this;
    }

    public List<ResourceTypeExtension> extensions() {
        return this.extensions;
    }

    public ResourceTypeEndpoint withExtensions(List<ResourceTypeExtension> extensions) {
        this.extensions = extensions;
        return this;
    }

    public Duration timeout() {
        return this.timeout;
    }

    public ResourceTypeEndpoint withTimeout(Duration timeout) {
        this.timeout = timeout;
        return this;
    }

    public EndpointTypeResourceType endpointType() {
        return this.endpointType;
    }

    public ResourceTypeEndpoint withEndpointType(EndpointTypeResourceType endpointType) {
        this.endpointType = endpointType;
        return this;
    }

    public TokenAuthConfiguration tokenAuthConfiguration() {
        return this.tokenAuthConfiguration;
    }

    public ResourceTypeEndpoint withTokenAuthConfiguration(TokenAuthConfiguration tokenAuthConfiguration) {
        this.tokenAuthConfiguration = tokenAuthConfiguration;
        return this;
    }

    public String skuLink() {
        return this.skuLink;
    }

    public ResourceTypeEndpoint withSkuLink(String skuLink) {
        this.skuLink = skuLink;
        return this;
    }

    public String endpointUri() {
        return this.endpointUri;
    }

    public ResourceTypeEndpoint withEndpointUri(String endpointUri) {
        this.endpointUri = endpointUri;
        return this;
    }

    public String apiVersion() {
        return this.apiVersion;
    }

    public ResourceTypeEndpoint withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    public List<String> zones() {
        return this.zones;
    }

    public ResourceTypeEndpoint withZones(List<String> zones) {
        this.zones = zones;
        return this;
    }

    public ResourceTypeEndpointDstsConfiguration dstsConfiguration() {
        return this.dstsConfiguration;
    }

    public ResourceTypeEndpoint withDstsConfiguration(ResourceTypeEndpointDstsConfiguration dstsConfiguration) {
        this.dstsConfiguration = dstsConfiguration;
        return this;
    }

    public DataBoundary dataBoundary() {
        return this.dataBoundary;
    }

    public ResourceTypeEndpoint withDataBoundary(DataBoundary dataBoundary) {
        this.dataBoundary = dataBoundary;
        return this;
    }

    public void validate() {
        if (this.featuresRule() != null) {
            this.featuresRule().validate();
        }
        if (this.extensions() != null) {
            this.extensions().forEach(e -> e.validate());
        }
        if (this.tokenAuthConfiguration() != null) {
            this.tokenAuthConfiguration().validate();
        }
        if (this.dstsConfiguration() != null) {
            this.dstsConfiguration().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kind", this.kind == null ? null : this.kind.toString());
        jsonWriter.writeBooleanField("enabled", this.enabled);
        jsonWriter.writeArrayField("apiVersions", this.apiVersions, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("locations", this.locations, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("requiredFeatures", this.requiredFeatures, (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("featuresRule", (JsonSerializable)this.featuresRule);
        jsonWriter.writeArrayField("extensions", this.extensions, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("timeout", CoreUtils.durationToStringWithDays((Duration)this.timeout));
        jsonWriter.writeStringField("endpointType", this.endpointType == null ? null : this.endpointType.toString());
        jsonWriter.writeJsonField("tokenAuthConfiguration", (JsonSerializable)this.tokenAuthConfiguration);
        jsonWriter.writeStringField("skuLink", this.skuLink);
        jsonWriter.writeStringField("endpointUri", this.endpointUri);
        jsonWriter.writeStringField("apiVersion", this.apiVersion);
        jsonWriter.writeArrayField("zones", this.zones, (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("dstsConfiguration", (JsonSerializable)this.dstsConfiguration);
        jsonWriter.writeStringField("dataBoundary", this.dataBoundary == null ? null : this.dataBoundary.toString());
        return jsonWriter.writeEndObject();
    }

    public static ResourceTypeEndpoint fromJson(JsonReader jsonReader) throws IOException {
        return (ResourceTypeEndpoint)jsonReader.readObject(reader -> {
            ResourceTypeEndpoint deserializedResourceTypeEndpoint = new ResourceTypeEndpoint();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("kind".equals(fieldName)) {
                    deserializedResourceTypeEndpoint.kind = ResourceTypeEndpointKind.fromString(reader.getString());
                    continue;
                }
                if ("enabled".equals(fieldName)) {
                    deserializedResourceTypeEndpoint.enabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("apiVersions".equals(fieldName)) {
                    List apiVersions;
                    deserializedResourceTypeEndpoint.apiVersions = apiVersions = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("locations".equals(fieldName)) {
                    List locations;
                    deserializedResourceTypeEndpoint.locations = locations = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("requiredFeatures".equals(fieldName)) {
                    List requiredFeatures;
                    deserializedResourceTypeEndpoint.requiredFeatures = requiredFeatures = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("featuresRule".equals(fieldName)) {
                    deserializedResourceTypeEndpoint.featuresRule = ResourceTypeEndpointFeaturesRule.fromJson(reader);
                    continue;
                }
                if ("extensions".equals(fieldName)) {
                    List extensions;
                    deserializedResourceTypeEndpoint.extensions = extensions = reader.readArray(reader1 -> ResourceTypeExtension.fromJson(reader1));
                    continue;
                }
                if ("timeout".equals(fieldName)) {
                    deserializedResourceTypeEndpoint.timeout = (Duration)reader.getNullable(nonNullReader -> Duration.parse(nonNullReader.getString()));
                    continue;
                }
                if ("endpointType".equals(fieldName)) {
                    deserializedResourceTypeEndpoint.endpointType = EndpointTypeResourceType.fromString(reader.getString());
                    continue;
                }
                if ("tokenAuthConfiguration".equals(fieldName)) {
                    deserializedResourceTypeEndpoint.tokenAuthConfiguration = TokenAuthConfiguration.fromJson(reader);
                    continue;
                }
                if ("skuLink".equals(fieldName)) {
                    deserializedResourceTypeEndpoint.skuLink = reader.getString();
                    continue;
                }
                if ("endpointUri".equals(fieldName)) {
                    deserializedResourceTypeEndpoint.endpointUri = reader.getString();
                    continue;
                }
                if ("apiVersion".equals(fieldName)) {
                    deserializedResourceTypeEndpoint.apiVersion = reader.getString();
                    continue;
                }
                if ("zones".equals(fieldName)) {
                    List zones;
                    deserializedResourceTypeEndpoint.zones = zones = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("dstsConfiguration".equals(fieldName)) {
                    deserializedResourceTypeEndpoint.dstsConfiguration = ResourceTypeEndpointDstsConfiguration.fromJson(reader);
                    continue;
                }
                if ("dataBoundary".equals(fieldName)) {
                    deserializedResourceTypeEndpoint.dataBoundary = DataBoundary.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedResourceTypeEndpoint;
        });
    }
}

