/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.providerhub.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.providerhub.models.AdditionalOptions;
import com.azure.resourcemanager.providerhub.models.AllowedUnauthorizedActionsExtension;
import com.azure.resourcemanager.providerhub.models.AuthorizationActionMapping;
import com.azure.resourcemanager.providerhub.models.CrossTenantTokenValidation;
import com.azure.resourcemanager.providerhub.models.ExtendedLocationOptions;
import com.azure.resourcemanager.providerhub.models.LinkedAccessCheck;
import com.azure.resourcemanager.providerhub.models.LinkedNotificationRule;
import com.azure.resourcemanager.providerhub.models.LinkedOperationRule;
import com.azure.resourcemanager.providerhub.models.LoggingRule;
import com.azure.resourcemanager.providerhub.models.ManifestResourceDeletionPolicy;
import com.azure.resourcemanager.providerhub.models.MarketplaceType;
import com.azure.resourcemanager.providerhub.models.Notification;
import com.azure.resourcemanager.providerhub.models.QuotaRule;
import com.azure.resourcemanager.providerhub.models.ResourceProviderAuthorizationRules;
import com.azure.resourcemanager.providerhub.models.ResourceProviderEndpoint;
import com.azure.resourcemanager.providerhub.models.ResourceTypeFeaturesRule;
import com.azure.resourcemanager.providerhub.models.ResourceTypeIdentityManagement;
import com.azure.resourcemanager.providerhub.models.ResourceTypeRequestHeaderOptions;
import com.azure.resourcemanager.providerhub.models.ResourceTypeTemplateDeploymentPolicy;
import com.azure.resourcemanager.providerhub.models.ResourceValidation;
import com.azure.resourcemanager.providerhub.models.RoutingType;
import com.azure.resourcemanager.providerhub.models.ServiceTreeInfo;
import com.azure.resourcemanager.providerhub.models.SubscriptionStateRule;
import com.azure.resourcemanager.providerhub.models.ThrottlingRule;
import java.io.IOException;
import java.util.List;

public final class ResourceType
implements JsonSerializable<ResourceType> {
    private String name;
    private RoutingType routingType;
    private AdditionalOptions additionalOptions;
    private CrossTenantTokenValidation crossTenantTokenValidation;
    private ResourceValidation resourceValidation;
    private List<String> allowedUnauthorizedActions;
    private List<AllowedUnauthorizedActionsExtension> allowedUnauthorizedActionsExtensions;
    private List<AuthorizationActionMapping> authorizationActionMappings;
    private List<LinkedAccessCheck> linkedAccessChecks;
    private String defaultApiVersion;
    private List<LoggingRule> loggingRules;
    private List<ThrottlingRule> throttlingRules;
    private List<ResourceProviderEndpoint> endpoints;
    private MarketplaceType marketplaceType;
    private ResourceTypeIdentityManagement identityManagement;
    private Object metadata;
    private List<String> requiredFeatures;
    private ResourceTypeFeaturesRule featuresRule;
    private List<SubscriptionStateRule> subscriptionStateRules;
    private List<ServiceTreeInfo> serviceTreeInfos;
    private ResourceTypeRequestHeaderOptions requestHeaderOptions;
    private String skuLink;
    private List<String> disallowedActionVerbs;
    private ResourceTypeTemplateDeploymentPolicy templateDeploymentPolicy;
    private List<ExtendedLocationOptions> extendedLocations;
    private List<LinkedOperationRule> linkedOperationRules;
    private ManifestResourceDeletionPolicy resourceDeletionPolicy;
    private QuotaRule quotaRule;
    private List<Notification> notifications;
    private List<LinkedNotificationRule> linkedNotificationRules;
    private ResourceProviderAuthorizationRules resourceProviderAuthorizationRules;

    public String name() {
        return this.name;
    }

    public ResourceType withName(String name) {
        this.name = name;
        return this;
    }

    public RoutingType routingType() {
        return this.routingType;
    }

    public ResourceType withRoutingType(RoutingType routingType) {
        this.routingType = routingType;
        return this;
    }

    public AdditionalOptions additionalOptions() {
        return this.additionalOptions;
    }

    public ResourceType withAdditionalOptions(AdditionalOptions additionalOptions) {
        this.additionalOptions = additionalOptions;
        return this;
    }

    public CrossTenantTokenValidation crossTenantTokenValidation() {
        return this.crossTenantTokenValidation;
    }

    public ResourceType withCrossTenantTokenValidation(CrossTenantTokenValidation crossTenantTokenValidation) {
        this.crossTenantTokenValidation = crossTenantTokenValidation;
        return this;
    }

    public ResourceValidation resourceValidation() {
        return this.resourceValidation;
    }

    public ResourceType withResourceValidation(ResourceValidation resourceValidation) {
        this.resourceValidation = resourceValidation;
        return this;
    }

    public List<String> allowedUnauthorizedActions() {
        return this.allowedUnauthorizedActions;
    }

    public ResourceType withAllowedUnauthorizedActions(List<String> allowedUnauthorizedActions) {
        this.allowedUnauthorizedActions = allowedUnauthorizedActions;
        return this;
    }

    public List<AllowedUnauthorizedActionsExtension> allowedUnauthorizedActionsExtensions() {
        return this.allowedUnauthorizedActionsExtensions;
    }

    public ResourceType withAllowedUnauthorizedActionsExtensions(List<AllowedUnauthorizedActionsExtension> allowedUnauthorizedActionsExtensions) {
        this.allowedUnauthorizedActionsExtensions = allowedUnauthorizedActionsExtensions;
        return this;
    }

    public List<AuthorizationActionMapping> authorizationActionMappings() {
        return this.authorizationActionMappings;
    }

    public ResourceType withAuthorizationActionMappings(List<AuthorizationActionMapping> authorizationActionMappings) {
        this.authorizationActionMappings = authorizationActionMappings;
        return this;
    }

    public List<LinkedAccessCheck> linkedAccessChecks() {
        return this.linkedAccessChecks;
    }

    public ResourceType withLinkedAccessChecks(List<LinkedAccessCheck> linkedAccessChecks) {
        this.linkedAccessChecks = linkedAccessChecks;
        return this;
    }

    public String defaultApiVersion() {
        return this.defaultApiVersion;
    }

    public ResourceType withDefaultApiVersion(String defaultApiVersion) {
        this.defaultApiVersion = defaultApiVersion;
        return this;
    }

    public List<LoggingRule> loggingRules() {
        return this.loggingRules;
    }

    public ResourceType withLoggingRules(List<LoggingRule> loggingRules) {
        this.loggingRules = loggingRules;
        return this;
    }

    public List<ThrottlingRule> throttlingRules() {
        return this.throttlingRules;
    }

    public ResourceType withThrottlingRules(List<ThrottlingRule> throttlingRules) {
        this.throttlingRules = throttlingRules;
        return this;
    }

    public List<ResourceProviderEndpoint> endpoints() {
        return this.endpoints;
    }

    public ResourceType withEndpoints(List<ResourceProviderEndpoint> endpoints) {
        this.endpoints = endpoints;
        return this;
    }

    public MarketplaceType marketplaceType() {
        return this.marketplaceType;
    }

    public ResourceType withMarketplaceType(MarketplaceType marketplaceType) {
        this.marketplaceType = marketplaceType;
        return this;
    }

    public ResourceTypeIdentityManagement identityManagement() {
        return this.identityManagement;
    }

    public ResourceType withIdentityManagement(ResourceTypeIdentityManagement identityManagement) {
        this.identityManagement = identityManagement;
        return this;
    }

    public Object metadata() {
        return this.metadata;
    }

    public ResourceType withMetadata(Object metadata) {
        this.metadata = metadata;
        return this;
    }

    public List<String> requiredFeatures() {
        return this.requiredFeatures;
    }

    public ResourceType withRequiredFeatures(List<String> requiredFeatures) {
        this.requiredFeatures = requiredFeatures;
        return this;
    }

    public ResourceTypeFeaturesRule featuresRule() {
        return this.featuresRule;
    }

    public ResourceType withFeaturesRule(ResourceTypeFeaturesRule featuresRule) {
        this.featuresRule = featuresRule;
        return this;
    }

    public List<SubscriptionStateRule> subscriptionStateRules() {
        return this.subscriptionStateRules;
    }

    public ResourceType withSubscriptionStateRules(List<SubscriptionStateRule> subscriptionStateRules) {
        this.subscriptionStateRules = subscriptionStateRules;
        return this;
    }

    public List<ServiceTreeInfo> serviceTreeInfos() {
        return this.serviceTreeInfos;
    }

    public ResourceType withServiceTreeInfos(List<ServiceTreeInfo> serviceTreeInfos) {
        this.serviceTreeInfos = serviceTreeInfos;
        return this;
    }

    public ResourceTypeRequestHeaderOptions requestHeaderOptions() {
        return this.requestHeaderOptions;
    }

    public ResourceType withRequestHeaderOptions(ResourceTypeRequestHeaderOptions requestHeaderOptions) {
        this.requestHeaderOptions = requestHeaderOptions;
        return this;
    }

    public String skuLink() {
        return this.skuLink;
    }

    public ResourceType withSkuLink(String skuLink) {
        this.skuLink = skuLink;
        return this;
    }

    public List<String> disallowedActionVerbs() {
        return this.disallowedActionVerbs;
    }

    public ResourceType withDisallowedActionVerbs(List<String> disallowedActionVerbs) {
        this.disallowedActionVerbs = disallowedActionVerbs;
        return this;
    }

    public ResourceTypeTemplateDeploymentPolicy templateDeploymentPolicy() {
        return this.templateDeploymentPolicy;
    }

    public ResourceType withTemplateDeploymentPolicy(ResourceTypeTemplateDeploymentPolicy templateDeploymentPolicy) {
        this.templateDeploymentPolicy = templateDeploymentPolicy;
        return this;
    }

    public List<ExtendedLocationOptions> extendedLocations() {
        return this.extendedLocations;
    }

    public ResourceType withExtendedLocations(List<ExtendedLocationOptions> extendedLocations) {
        this.extendedLocations = extendedLocations;
        return this;
    }

    public List<LinkedOperationRule> linkedOperationRules() {
        return this.linkedOperationRules;
    }

    public ResourceType withLinkedOperationRules(List<LinkedOperationRule> linkedOperationRules) {
        this.linkedOperationRules = linkedOperationRules;
        return this;
    }

    public ManifestResourceDeletionPolicy resourceDeletionPolicy() {
        return this.resourceDeletionPolicy;
    }

    public ResourceType withResourceDeletionPolicy(ManifestResourceDeletionPolicy resourceDeletionPolicy) {
        this.resourceDeletionPolicy = resourceDeletionPolicy;
        return this;
    }

    public QuotaRule quotaRule() {
        return this.quotaRule;
    }

    public ResourceType withQuotaRule(QuotaRule quotaRule) {
        this.quotaRule = quotaRule;
        return this;
    }

    public List<Notification> notifications() {
        return this.notifications;
    }

    public ResourceType withNotifications(List<Notification> notifications) {
        this.notifications = notifications;
        return this;
    }

    public List<LinkedNotificationRule> linkedNotificationRules() {
        return this.linkedNotificationRules;
    }

    public ResourceType withLinkedNotificationRules(List<LinkedNotificationRule> linkedNotificationRules) {
        this.linkedNotificationRules = linkedNotificationRules;
        return this;
    }

    public ResourceProviderAuthorizationRules resourceProviderAuthorizationRules() {
        return this.resourceProviderAuthorizationRules;
    }

    public ResourceType withResourceProviderAuthorizationRules(ResourceProviderAuthorizationRules resourceProviderAuthorizationRules) {
        this.resourceProviderAuthorizationRules = resourceProviderAuthorizationRules;
        return this;
    }

    public void validate() {
        if (this.allowedUnauthorizedActionsExtensions() != null) {
            this.allowedUnauthorizedActionsExtensions().forEach(e -> e.validate());
        }
        if (this.authorizationActionMappings() != null) {
            this.authorizationActionMappings().forEach(e -> e.validate());
        }
        if (this.linkedAccessChecks() != null) {
            this.linkedAccessChecks().forEach(e -> e.validate());
        }
        if (this.loggingRules() != null) {
            this.loggingRules().forEach(e -> e.validate());
        }
        if (this.throttlingRules() != null) {
            this.throttlingRules().forEach(e -> e.validate());
        }
        if (this.endpoints() != null) {
            this.endpoints().forEach(e -> e.validate());
        }
        if (this.identityManagement() != null) {
            this.identityManagement().validate();
        }
        if (this.featuresRule() != null) {
            this.featuresRule().validate();
        }
        if (this.subscriptionStateRules() != null) {
            this.subscriptionStateRules().forEach(e -> e.validate());
        }
        if (this.serviceTreeInfos() != null) {
            this.serviceTreeInfos().forEach(e -> e.validate());
        }
        if (this.requestHeaderOptions() != null) {
            this.requestHeaderOptions().validate();
        }
        if (this.templateDeploymentPolicy() != null) {
            this.templateDeploymentPolicy().validate();
        }
        if (this.extendedLocations() != null) {
            this.extendedLocations().forEach(e -> e.validate());
        }
        if (this.linkedOperationRules() != null) {
            this.linkedOperationRules().forEach(e -> e.validate());
        }
        if (this.quotaRule() != null) {
            this.quotaRule().validate();
        }
        if (this.notifications() != null) {
            this.notifications().forEach(e -> e.validate());
        }
        if (this.linkedNotificationRules() != null) {
            this.linkedNotificationRules().forEach(e -> e.validate());
        }
        if (this.resourceProviderAuthorizationRules() != null) {
            this.resourceProviderAuthorizationRules().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("routingType", this.routingType == null ? null : this.routingType.toString());
        jsonWriter.writeStringField("additionalOptions", this.additionalOptions == null ? null : this.additionalOptions.toString());
        jsonWriter.writeStringField("crossTenantTokenValidation", this.crossTenantTokenValidation == null ? null : this.crossTenantTokenValidation.toString());
        jsonWriter.writeStringField("resourceValidation", this.resourceValidation == null ? null : this.resourceValidation.toString());
        jsonWriter.writeArrayField("allowedUnauthorizedActions", this.allowedUnauthorizedActions, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("allowedUnauthorizedActionsExtensions", this.allowedUnauthorizedActionsExtensions, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("authorizationActionMappings", this.authorizationActionMappings, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("linkedAccessChecks", this.linkedAccessChecks, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("defaultApiVersion", this.defaultApiVersion);
        jsonWriter.writeArrayField("loggingRules", this.loggingRules, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("throttlingRules", this.throttlingRules, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("endpoints", this.endpoints, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("marketplaceType", this.marketplaceType == null ? null : this.marketplaceType.toString());
        jsonWriter.writeJsonField("identityManagement", (JsonSerializable)this.identityManagement);
        if (this.metadata != null) {
            jsonWriter.writeUntypedField("metadata", this.metadata);
        }
        jsonWriter.writeArrayField("requiredFeatures", this.requiredFeatures, (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("featuresRule", (JsonSerializable)this.featuresRule);
        jsonWriter.writeArrayField("subscriptionStateRules", this.subscriptionStateRules, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("serviceTreeInfos", this.serviceTreeInfos, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("requestHeaderOptions", (JsonSerializable)this.requestHeaderOptions);
        jsonWriter.writeStringField("skuLink", this.skuLink);
        jsonWriter.writeArrayField("disallowedActionVerbs", this.disallowedActionVerbs, (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("templateDeploymentPolicy", (JsonSerializable)this.templateDeploymentPolicy);
        jsonWriter.writeArrayField("extendedLocations", this.extendedLocations, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("linkedOperationRules", this.linkedOperationRules, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("resourceDeletionPolicy", this.resourceDeletionPolicy == null ? null : this.resourceDeletionPolicy.toString());
        jsonWriter.writeJsonField("quotaRule", (JsonSerializable)this.quotaRule);
        jsonWriter.writeArrayField("notifications", this.notifications, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("linkedNotificationRules", this.linkedNotificationRules, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("resourceProviderAuthorizationRules", (JsonSerializable)this.resourceProviderAuthorizationRules);
        return jsonWriter.writeEndObject();
    }

    public static ResourceType fromJson(JsonReader jsonReader) throws IOException {
        return (ResourceType)jsonReader.readObject(reader -> {
            ResourceType deserializedResourceType = new ResourceType();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedResourceType.name = reader.getString();
                    continue;
                }
                if ("routingType".equals(fieldName)) {
                    deserializedResourceType.routingType = RoutingType.fromString(reader.getString());
                    continue;
                }
                if ("additionalOptions".equals(fieldName)) {
                    deserializedResourceType.additionalOptions = AdditionalOptions.fromString(reader.getString());
                    continue;
                }
                if ("crossTenantTokenValidation".equals(fieldName)) {
                    deserializedResourceType.crossTenantTokenValidation = CrossTenantTokenValidation.fromString(reader.getString());
                    continue;
                }
                if ("resourceValidation".equals(fieldName)) {
                    deserializedResourceType.resourceValidation = ResourceValidation.fromString(reader.getString());
                    continue;
                }
                if ("allowedUnauthorizedActions".equals(fieldName)) {
                    List allowedUnauthorizedActions;
                    deserializedResourceType.allowedUnauthorizedActions = allowedUnauthorizedActions = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("allowedUnauthorizedActionsExtensions".equals(fieldName)) {
                    List allowedUnauthorizedActionsExtensions;
                    deserializedResourceType.allowedUnauthorizedActionsExtensions = allowedUnauthorizedActionsExtensions = reader.readArray(reader1 -> AllowedUnauthorizedActionsExtension.fromJson(reader1));
                    continue;
                }
                if ("authorizationActionMappings".equals(fieldName)) {
                    List authorizationActionMappings;
                    deserializedResourceType.authorizationActionMappings = authorizationActionMappings = reader.readArray(reader1 -> AuthorizationActionMapping.fromJson(reader1));
                    continue;
                }
                if ("linkedAccessChecks".equals(fieldName)) {
                    List linkedAccessChecks;
                    deserializedResourceType.linkedAccessChecks = linkedAccessChecks = reader.readArray(reader1 -> LinkedAccessCheck.fromJson(reader1));
                    continue;
                }
                if ("defaultApiVersion".equals(fieldName)) {
                    deserializedResourceType.defaultApiVersion = reader.getString();
                    continue;
                }
                if ("loggingRules".equals(fieldName)) {
                    List loggingRules;
                    deserializedResourceType.loggingRules = loggingRules = reader.readArray(reader1 -> LoggingRule.fromJson(reader1));
                    continue;
                }
                if ("throttlingRules".equals(fieldName)) {
                    List throttlingRules;
                    deserializedResourceType.throttlingRules = throttlingRules = reader.readArray(reader1 -> ThrottlingRule.fromJson(reader1));
                    continue;
                }
                if ("endpoints".equals(fieldName)) {
                    List endpoints;
                    deserializedResourceType.endpoints = endpoints = reader.readArray(reader1 -> ResourceProviderEndpoint.fromJson(reader1));
                    continue;
                }
                if ("marketplaceType".equals(fieldName)) {
                    deserializedResourceType.marketplaceType = MarketplaceType.fromString(reader.getString());
                    continue;
                }
                if ("identityManagement".equals(fieldName)) {
                    deserializedResourceType.identityManagement = ResourceTypeIdentityManagement.fromJson(reader);
                    continue;
                }
                if ("metadata".equals(fieldName)) {
                    deserializedResourceType.metadata = reader.readUntyped();
                    continue;
                }
                if ("requiredFeatures".equals(fieldName)) {
                    List requiredFeatures;
                    deserializedResourceType.requiredFeatures = requiredFeatures = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("featuresRule".equals(fieldName)) {
                    deserializedResourceType.featuresRule = ResourceTypeFeaturesRule.fromJson(reader);
                    continue;
                }
                if ("subscriptionStateRules".equals(fieldName)) {
                    List subscriptionStateRules;
                    deserializedResourceType.subscriptionStateRules = subscriptionStateRules = reader.readArray(reader1 -> SubscriptionStateRule.fromJson(reader1));
                    continue;
                }
                if ("serviceTreeInfos".equals(fieldName)) {
                    List serviceTreeInfos;
                    deserializedResourceType.serviceTreeInfos = serviceTreeInfos = reader.readArray(reader1 -> ServiceTreeInfo.fromJson(reader1));
                    continue;
                }
                if ("requestHeaderOptions".equals(fieldName)) {
                    deserializedResourceType.requestHeaderOptions = ResourceTypeRequestHeaderOptions.fromJson(reader);
                    continue;
                }
                if ("skuLink".equals(fieldName)) {
                    deserializedResourceType.skuLink = reader.getString();
                    continue;
                }
                if ("disallowedActionVerbs".equals(fieldName)) {
                    List disallowedActionVerbs;
                    deserializedResourceType.disallowedActionVerbs = disallowedActionVerbs = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("templateDeploymentPolicy".equals(fieldName)) {
                    deserializedResourceType.templateDeploymentPolicy = ResourceTypeTemplateDeploymentPolicy.fromJson(reader);
                    continue;
                }
                if ("extendedLocations".equals(fieldName)) {
                    List extendedLocations;
                    deserializedResourceType.extendedLocations = extendedLocations = reader.readArray(reader1 -> ExtendedLocationOptions.fromJson(reader1));
                    continue;
                }
                if ("linkedOperationRules".equals(fieldName)) {
                    List linkedOperationRules;
                    deserializedResourceType.linkedOperationRules = linkedOperationRules = reader.readArray(reader1 -> LinkedOperationRule.fromJson(reader1));
                    continue;
                }
                if ("resourceDeletionPolicy".equals(fieldName)) {
                    deserializedResourceType.resourceDeletionPolicy = ManifestResourceDeletionPolicy.fromString(reader.getString());
                    continue;
                }
                if ("quotaRule".equals(fieldName)) {
                    deserializedResourceType.quotaRule = QuotaRule.fromJson(reader);
                    continue;
                }
                if ("notifications".equals(fieldName)) {
                    List notifications;
                    deserializedResourceType.notifications = notifications = reader.readArray(reader1 -> Notification.fromJson(reader1));
                    continue;
                }
                if ("linkedNotificationRules".equals(fieldName)) {
                    List linkedNotificationRules;
                    deserializedResourceType.linkedNotificationRules = linkedNotificationRules = reader.readArray(reader1 -> LinkedNotificationRule.fromJson(reader1));
                    continue;
                }
                if ("resourceProviderAuthorizationRules".equals(fieldName)) {
                    deserializedResourceType.resourceProviderAuthorizationRules = ResourceProviderAuthorizationRules.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedResourceType;
        });
    }
}

