/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.providerhub.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.providerhub.models.ServiceStatus;
import java.io.IOException;

public final class ResourceProviderService
implements JsonSerializable<ResourceProviderService> {
    private String serviceName;
    private ServiceStatus status;

    public String serviceName() {
        return this.serviceName;
    }

    public ResourceProviderService withServiceName(String serviceName) {
        this.serviceName = serviceName;
        return this;
    }

    public ServiceStatus status() {
        return this.status;
    }

    public ResourceProviderService withStatus(ServiceStatus status) {
        this.status = status;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("serviceName", this.serviceName);
        jsonWriter.writeStringField("status", this.status == null ? null : this.status.toString());
        return jsonWriter.writeEndObject();
    }

    public static ResourceProviderService fromJson(JsonReader jsonReader) throws IOException {
        return (ResourceProviderService)jsonReader.readObject(reader -> {
            ResourceProviderService deserializedResourceProviderService = new ResourceProviderService();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("serviceName".equals(fieldName)) {
                    deserializedResourceProviderService.serviceName = reader.getString();
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedResourceProviderService.status = ServiceStatus.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedResourceProviderService;
        });
    }
}

