/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.providerhub.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.providerhub.models.ResourceProviderAuthentication;
import java.io.IOException;
import java.util.List;

public final class ResourceProviderManifestProviderAuthentication
extends ResourceProviderAuthentication {
    private static final ClientLogger LOGGER = new ClientLogger(ResourceProviderManifestProviderAuthentication.class);

    @Override
    public ResourceProviderManifestProviderAuthentication withAllowedAudiences(List<String> allowedAudiences) {
        super.withAllowedAudiences(allowedAudiences);
        return this;
    }

    @Override
    public void validate() {
        if (this.allowedAudiences() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property allowedAudiences in model ResourceProviderManifestProviderAuthentication"));
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("allowedAudiences", this.allowedAudiences(), (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static ResourceProviderManifestProviderAuthentication fromJson(JsonReader jsonReader) throws IOException {
        return (ResourceProviderManifestProviderAuthentication)jsonReader.readObject(reader -> {
            ResourceProviderManifestProviderAuthentication deserializedResourceProviderManifestProviderAuthentication = new ResourceProviderManifestProviderAuthentication();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("allowedAudiences".equals(fieldName)) {
                    List allowedAudiences = reader.readArray(reader1 -> reader1.getString());
                    deserializedResourceProviderManifestProviderAuthentication.withAllowedAudiences(allowedAudiences);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedResourceProviderManifestProviderAuthentication;
        });
    }
}

