/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.providerhub.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.providerhub.models.ResourceProviderAuthentication;
import java.io.IOException;
import java.util.List;

public final class ResourceProviderManifestPropertiesProviderAuthentication
extends ResourceProviderAuthentication {
    private static final ClientLogger LOGGER = new ClientLogger(ResourceProviderManifestPropertiesProviderAuthentication.class);

    @Override
    public ResourceProviderManifestPropertiesProviderAuthentication withAllowedAudiences(List<String> allowedAudiences) {
        super.withAllowedAudiences(allowedAudiences);
        return this;
    }

    @Override
    public void validate() {
        if (this.allowedAudiences() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property allowedAudiences in model ResourceProviderManifestPropertiesProviderAuthentication"));
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("allowedAudiences", this.allowedAudiences(), (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static ResourceProviderManifestPropertiesProviderAuthentication fromJson(JsonReader jsonReader) throws IOException {
        return (ResourceProviderManifestPropertiesProviderAuthentication)jsonReader.readObject(reader -> {
            ResourceProviderManifestPropertiesProviderAuthentication deserializedResourceProviderManifestPropertiesProviderAuthentication = new ResourceProviderManifestPropertiesProviderAuthentication();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("allowedAudiences".equals(fieldName)) {
                    List allowedAudiences = reader.readArray(reader1 -> reader1.getString());
                    deserializedResourceProviderManifestPropertiesProviderAuthentication.withAllowedAudiences(allowedAudiences);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedResourceProviderManifestPropertiesProviderAuthentication;
        });
    }
}

