/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.providerhub.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.providerhub.models.ResourceAccessPolicy;
import com.azure.resourcemanager.providerhub.models.ResourceAccessRole;
import com.azure.resourcemanager.providerhub.models.ResourceProviderManagement;
import com.azure.resourcemanager.providerhub.models.ResourceProviderManagementErrorResponseMessageOptions;
import com.azure.resourcemanager.providerhub.models.ResourceProviderManagementExpeditedRolloutMetadata;
import com.azure.resourcemanager.providerhub.models.ServiceTreeInfo;
import java.io.IOException;
import java.util.List;

public final class ResourceProviderManifestPropertiesManagement
extends ResourceProviderManagement {
    @Override
    public ResourceProviderManifestPropertiesManagement withSchemaOwners(List<String> schemaOwners) {
        super.withSchemaOwners(schemaOwners);
        return this;
    }

    @Override
    public ResourceProviderManifestPropertiesManagement withManifestOwners(List<String> manifestOwners) {
        super.withManifestOwners(manifestOwners);
        return this;
    }

    @Override
    public ResourceProviderManifestPropertiesManagement withAuthorizationOwners(List<String> authorizationOwners) {
        super.withAuthorizationOwners(authorizationOwners);
        return this;
    }

    @Override
    public ResourceProviderManifestPropertiesManagement withIncidentRoutingService(String incidentRoutingService) {
        super.withIncidentRoutingService(incidentRoutingService);
        return this;
    }

    @Override
    public ResourceProviderManifestPropertiesManagement withIncidentRoutingTeam(String incidentRoutingTeam) {
        super.withIncidentRoutingTeam(incidentRoutingTeam);
        return this;
    }

    @Override
    public ResourceProviderManifestPropertiesManagement withIncidentContactEmail(String incidentContactEmail) {
        super.withIncidentContactEmail(incidentContactEmail);
        return this;
    }

    @Override
    public ResourceProviderManifestPropertiesManagement withServiceTreeInfos(List<ServiceTreeInfo> serviceTreeInfos) {
        super.withServiceTreeInfos(serviceTreeInfos);
        return this;
    }

    @Override
    public ResourceProviderManifestPropertiesManagement withResourceAccessPolicy(ResourceAccessPolicy resourceAccessPolicy) {
        super.withResourceAccessPolicy(resourceAccessPolicy);
        return this;
    }

    @Override
    public ResourceProviderManifestPropertiesManagement withResourceAccessRoles(List<ResourceAccessRole> resourceAccessRoles) {
        super.withResourceAccessRoles(resourceAccessRoles);
        return this;
    }

    @Override
    public ResourceProviderManifestPropertiesManagement withExpeditedRolloutSubmitters(List<String> expeditedRolloutSubmitters) {
        super.withExpeditedRolloutSubmitters(expeditedRolloutSubmitters);
        return this;
    }

    @Override
    public ResourceProviderManifestPropertiesManagement withErrorResponseMessageOptions(ResourceProviderManagementErrorResponseMessageOptions errorResponseMessageOptions) {
        super.withErrorResponseMessageOptions(errorResponseMessageOptions);
        return this;
    }

    @Override
    public ResourceProviderManifestPropertiesManagement withExpeditedRolloutMetadata(ResourceProviderManagementExpeditedRolloutMetadata expeditedRolloutMetadata) {
        super.withExpeditedRolloutMetadata(expeditedRolloutMetadata);
        return this;
    }

    @Override
    public ResourceProviderManifestPropertiesManagement withCanaryManifestOwners(List<String> canaryManifestOwners) {
        super.withCanaryManifestOwners(canaryManifestOwners);
        return this;
    }

    @Override
    public ResourceProviderManifestPropertiesManagement withPcCode(String pcCode) {
        super.withPcCode(pcCode);
        return this;
    }

    @Override
    public ResourceProviderManifestPropertiesManagement withProfitCenterProgramId(String profitCenterProgramId) {
        super.withProfitCenterProgramId(profitCenterProgramId);
        return this;
    }

    @Override
    public void validate() {
        if (this.serviceTreeInfos() != null) {
            this.serviceTreeInfos().forEach(e -> e.validate());
        }
        if (this.resourceAccessRoles() != null) {
            this.resourceAccessRoles().forEach(e -> e.validate());
        }
        if (this.errorResponseMessageOptions() != null) {
            this.errorResponseMessageOptions().validate();
        }
        if (this.expeditedRolloutMetadata() != null) {
            this.expeditedRolloutMetadata().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("schemaOwners", this.schemaOwners(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("manifestOwners", this.manifestOwners(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("authorizationOwners", this.authorizationOwners(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("incidentRoutingService", this.incidentRoutingService());
        jsonWriter.writeStringField("incidentRoutingTeam", this.incidentRoutingTeam());
        jsonWriter.writeStringField("incidentContactEmail", this.incidentContactEmail());
        jsonWriter.writeArrayField("serviceTreeInfos", this.serviceTreeInfos(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("resourceAccessPolicy", this.resourceAccessPolicy() == null ? null : this.resourceAccessPolicy().toString());
        jsonWriter.writeArrayField("resourceAccessRoles", this.resourceAccessRoles(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("expeditedRolloutSubmitters", this.expeditedRolloutSubmitters(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("errorResponseMessageOptions", (JsonSerializable)this.errorResponseMessageOptions());
        jsonWriter.writeJsonField("expeditedRolloutMetadata", (JsonSerializable)this.expeditedRolloutMetadata());
        jsonWriter.writeArrayField("canaryManifestOwners", this.canaryManifestOwners(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("pcCode", this.pcCode());
        jsonWriter.writeStringField("profitCenterProgramId", this.profitCenterProgramId());
        return jsonWriter.writeEndObject();
    }

    public static ResourceProviderManifestPropertiesManagement fromJson(JsonReader jsonReader) throws IOException {
        return (ResourceProviderManifestPropertiesManagement)jsonReader.readObject(reader -> {
            ResourceProviderManifestPropertiesManagement deserializedResourceProviderManifestPropertiesManagement = new ResourceProviderManifestPropertiesManagement();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("schemaOwners".equals(fieldName)) {
                    List schemaOwners = reader.readArray(reader1 -> reader1.getString());
                    deserializedResourceProviderManifestPropertiesManagement.withSchemaOwners(schemaOwners);
                    continue;
                }
                if ("manifestOwners".equals(fieldName)) {
                    List manifestOwners = reader.readArray(reader1 -> reader1.getString());
                    deserializedResourceProviderManifestPropertiesManagement.withManifestOwners(manifestOwners);
                    continue;
                }
                if ("authorizationOwners".equals(fieldName)) {
                    List authorizationOwners = reader.readArray(reader1 -> reader1.getString());
                    deserializedResourceProviderManifestPropertiesManagement.withAuthorizationOwners(authorizationOwners);
                    continue;
                }
                if ("incidentRoutingService".equals(fieldName)) {
                    deserializedResourceProviderManifestPropertiesManagement.withIncidentRoutingService(reader.getString());
                    continue;
                }
                if ("incidentRoutingTeam".equals(fieldName)) {
                    deserializedResourceProviderManifestPropertiesManagement.withIncidentRoutingTeam(reader.getString());
                    continue;
                }
                if ("incidentContactEmail".equals(fieldName)) {
                    deserializedResourceProviderManifestPropertiesManagement.withIncidentContactEmail(reader.getString());
                    continue;
                }
                if ("serviceTreeInfos".equals(fieldName)) {
                    List serviceTreeInfos = reader.readArray(reader1 -> ServiceTreeInfo.fromJson(reader1));
                    deserializedResourceProviderManifestPropertiesManagement.withServiceTreeInfos(serviceTreeInfos);
                    continue;
                }
                if ("resourceAccessPolicy".equals(fieldName)) {
                    deserializedResourceProviderManifestPropertiesManagement.withResourceAccessPolicy(ResourceAccessPolicy.fromString(reader.getString()));
                    continue;
                }
                if ("resourceAccessRoles".equals(fieldName)) {
                    List resourceAccessRoles = reader.readArray(reader1 -> ResourceAccessRole.fromJson(reader1));
                    deserializedResourceProviderManifestPropertiesManagement.withResourceAccessRoles(resourceAccessRoles);
                    continue;
                }
                if ("expeditedRolloutSubmitters".equals(fieldName)) {
                    List expeditedRolloutSubmitters = reader.readArray(reader1 -> reader1.getString());
                    deserializedResourceProviderManifestPropertiesManagement.withExpeditedRolloutSubmitters(expeditedRolloutSubmitters);
                    continue;
                }
                if ("errorResponseMessageOptions".equals(fieldName)) {
                    deserializedResourceProviderManifestPropertiesManagement.withErrorResponseMessageOptions(ResourceProviderManagementErrorResponseMessageOptions.fromJson(reader));
                    continue;
                }
                if ("expeditedRolloutMetadata".equals(fieldName)) {
                    deserializedResourceProviderManifestPropertiesManagement.withExpeditedRolloutMetadata(ResourceProviderManagementExpeditedRolloutMetadata.fromJson(reader));
                    continue;
                }
                if ("canaryManifestOwners".equals(fieldName)) {
                    List canaryManifestOwners = reader.readArray(reader1 -> reader1.getString());
                    deserializedResourceProviderManifestPropertiesManagement.withCanaryManifestOwners(canaryManifestOwners);
                    continue;
                }
                if ("pcCode".equals(fieldName)) {
                    deserializedResourceProviderManifestPropertiesManagement.withPcCode(reader.getString());
                    continue;
                }
                if ("profitCenterProgramId".equals(fieldName)) {
                    deserializedResourceProviderManifestPropertiesManagement.withProfitCenterProgramId(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedResourceProviderManifestPropertiesManagement;
        });
    }
}

