/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.providerhub.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.providerhub.models.CrossTenantTokenValidation;
import com.azure.resourcemanager.providerhub.models.FanoutLinkedNotificationRule;
import com.azure.resourcemanager.providerhub.models.Notification;
import com.azure.resourcemanager.providerhub.models.NotificationOptions;
import com.azure.resourcemanager.providerhub.models.ResourceHydrationAccount;
import com.azure.resourcemanager.providerhub.models.ResourceProviderAuthorization;
import com.azure.resourcemanager.providerhub.models.ResourceProviderAuthorizationRules;
import com.azure.resourcemanager.providerhub.models.ResourceProviderCapabilities;
import com.azure.resourcemanager.providerhub.models.ResourceProviderEndpoint;
import com.azure.resourcemanager.providerhub.models.ResourceProviderManifestPropertiesDstsConfiguration;
import com.azure.resourcemanager.providerhub.models.ResourceProviderManifestPropertiesFeaturesRule;
import com.azure.resourcemanager.providerhub.models.ResourceProviderManifestPropertiesManagement;
import com.azure.resourcemanager.providerhub.models.ResourceProviderManifestPropertiesNotificationSettings;
import com.azure.resourcemanager.providerhub.models.ResourceProviderManifestPropertiesProviderAuthentication;
import com.azure.resourcemanager.providerhub.models.ResourceProviderManifestPropertiesRequestHeaderOptions;
import com.azure.resourcemanager.providerhub.models.ResourceProviderManifestPropertiesResourceGroupLockOptionDuringMove;
import com.azure.resourcemanager.providerhub.models.ResourceProviderManifestPropertiesResponseOptions;
import com.azure.resourcemanager.providerhub.models.ResourceProviderManifestPropertiesTemplateDeploymentOptions;
import com.azure.resourcemanager.providerhub.models.ResourceProviderService;
import com.azure.resourcemanager.providerhub.models.ResourceProviderType;
import java.io.IOException;
import java.util.List;

public class ResourceProviderManifestProperties
implements JsonSerializable<ResourceProviderManifestProperties> {
    private ResourceProviderManifestPropertiesProviderAuthentication providerAuthentication;
    private List<ResourceProviderAuthorization> providerAuthorizations;
    private String namespace;
    private List<ResourceProviderService> services;
    private String serviceName;
    private String providerVersion;
    private ResourceProviderType providerType;
    private List<String> requiredFeatures;
    private ResourceProviderManifestPropertiesFeaturesRule featuresRule;
    private ResourceProviderManifestPropertiesRequestHeaderOptions requestHeaderOptions;
    private ResourceProviderManifestPropertiesManagement management;
    private List<ResourceProviderCapabilities> capabilities;
    private CrossTenantTokenValidation crossTenantTokenValidation;
    private Object metadata;
    private ResourceProviderManifestPropertiesTemplateDeploymentOptions templateDeploymentOptions;
    private List<ResourceProviderEndpoint> globalNotificationEndpoints;
    private Boolean enableTenantLinkedNotification;
    private List<Notification> notifications;
    private List<FanoutLinkedNotificationRule> linkedNotificationRules;
    private ResourceProviderAuthorizationRules resourceProviderAuthorizationRules;
    private ResourceProviderManifestPropertiesDstsConfiguration dstsConfiguration;
    private NotificationOptions notificationOptions;
    private List<ResourceHydrationAccount> resourceHydrationAccounts;
    private ResourceProviderManifestPropertiesNotificationSettings notificationSettings;
    private List<ResourceProviderEndpoint> managementGroupGlobalNotificationEndpoints;
    private List<String> optionalFeatures;
    private ResourceProviderManifestPropertiesResourceGroupLockOptionDuringMove resourceGroupLockOptionDuringMove;
    private ResourceProviderManifestPropertiesResponseOptions responseOptions;
    private String legacyNamespace;
    private List<String> legacyRegistrations;
    private String customManifestVersion;

    public ResourceProviderManifestPropertiesProviderAuthentication providerAuthentication() {
        return this.providerAuthentication;
    }

    public ResourceProviderManifestProperties withProviderAuthentication(ResourceProviderManifestPropertiesProviderAuthentication providerAuthentication) {
        this.providerAuthentication = providerAuthentication;
        return this;
    }

    public List<ResourceProviderAuthorization> providerAuthorizations() {
        return this.providerAuthorizations;
    }

    public ResourceProviderManifestProperties withProviderAuthorizations(List<ResourceProviderAuthorization> providerAuthorizations) {
        this.providerAuthorizations = providerAuthorizations;
        return this;
    }

    public String namespace() {
        return this.namespace;
    }

    public ResourceProviderManifestProperties withNamespace(String namespace) {
        this.namespace = namespace;
        return this;
    }

    public List<ResourceProviderService> services() {
        return this.services;
    }

    public ResourceProviderManifestProperties withServices(List<ResourceProviderService> services) {
        this.services = services;
        return this;
    }

    public String serviceName() {
        return this.serviceName;
    }

    public ResourceProviderManifestProperties withServiceName(String serviceName) {
        this.serviceName = serviceName;
        return this;
    }

    public String providerVersion() {
        return this.providerVersion;
    }

    public ResourceProviderManifestProperties withProviderVersion(String providerVersion) {
        this.providerVersion = providerVersion;
        return this;
    }

    public ResourceProviderType providerType() {
        return this.providerType;
    }

    public ResourceProviderManifestProperties withProviderType(ResourceProviderType providerType) {
        this.providerType = providerType;
        return this;
    }

    public List<String> requiredFeatures() {
        return this.requiredFeatures;
    }

    public ResourceProviderManifestProperties withRequiredFeatures(List<String> requiredFeatures) {
        this.requiredFeatures = requiredFeatures;
        return this;
    }

    public ResourceProviderManifestPropertiesFeaturesRule featuresRule() {
        return this.featuresRule;
    }

    public ResourceProviderManifestProperties withFeaturesRule(ResourceProviderManifestPropertiesFeaturesRule featuresRule) {
        this.featuresRule = featuresRule;
        return this;
    }

    public ResourceProviderManifestPropertiesRequestHeaderOptions requestHeaderOptions() {
        return this.requestHeaderOptions;
    }

    public ResourceProviderManifestProperties withRequestHeaderOptions(ResourceProviderManifestPropertiesRequestHeaderOptions requestHeaderOptions) {
        this.requestHeaderOptions = requestHeaderOptions;
        return this;
    }

    public ResourceProviderManifestPropertiesManagement management() {
        return this.management;
    }

    public ResourceProviderManifestProperties withManagement(ResourceProviderManifestPropertiesManagement management) {
        this.management = management;
        return this;
    }

    public List<ResourceProviderCapabilities> capabilities() {
        return this.capabilities;
    }

    public ResourceProviderManifestProperties withCapabilities(List<ResourceProviderCapabilities> capabilities) {
        this.capabilities = capabilities;
        return this;
    }

    public CrossTenantTokenValidation crossTenantTokenValidation() {
        return this.crossTenantTokenValidation;
    }

    public ResourceProviderManifestProperties withCrossTenantTokenValidation(CrossTenantTokenValidation crossTenantTokenValidation) {
        this.crossTenantTokenValidation = crossTenantTokenValidation;
        return this;
    }

    public Object metadata() {
        return this.metadata;
    }

    public ResourceProviderManifestProperties withMetadata(Object metadata) {
        this.metadata = metadata;
        return this;
    }

    public ResourceProviderManifestPropertiesTemplateDeploymentOptions templateDeploymentOptions() {
        return this.templateDeploymentOptions;
    }

    public ResourceProviderManifestProperties withTemplateDeploymentOptions(ResourceProviderManifestPropertiesTemplateDeploymentOptions templateDeploymentOptions) {
        this.templateDeploymentOptions = templateDeploymentOptions;
        return this;
    }

    public List<ResourceProviderEndpoint> globalNotificationEndpoints() {
        return this.globalNotificationEndpoints;
    }

    public ResourceProviderManifestProperties withGlobalNotificationEndpoints(List<ResourceProviderEndpoint> globalNotificationEndpoints) {
        this.globalNotificationEndpoints = globalNotificationEndpoints;
        return this;
    }

    public Boolean enableTenantLinkedNotification() {
        return this.enableTenantLinkedNotification;
    }

    public ResourceProviderManifestProperties withEnableTenantLinkedNotification(Boolean enableTenantLinkedNotification) {
        this.enableTenantLinkedNotification = enableTenantLinkedNotification;
        return this;
    }

    public List<Notification> notifications() {
        return this.notifications;
    }

    public ResourceProviderManifestProperties withNotifications(List<Notification> notifications) {
        this.notifications = notifications;
        return this;
    }

    public List<FanoutLinkedNotificationRule> linkedNotificationRules() {
        return this.linkedNotificationRules;
    }

    public ResourceProviderManifestProperties withLinkedNotificationRules(List<FanoutLinkedNotificationRule> linkedNotificationRules) {
        this.linkedNotificationRules = linkedNotificationRules;
        return this;
    }

    public ResourceProviderAuthorizationRules resourceProviderAuthorizationRules() {
        return this.resourceProviderAuthorizationRules;
    }

    public ResourceProviderManifestProperties withResourceProviderAuthorizationRules(ResourceProviderAuthorizationRules resourceProviderAuthorizationRules) {
        this.resourceProviderAuthorizationRules = resourceProviderAuthorizationRules;
        return this;
    }

    public ResourceProviderManifestPropertiesDstsConfiguration dstsConfiguration() {
        return this.dstsConfiguration;
    }

    public ResourceProviderManifestProperties withDstsConfiguration(ResourceProviderManifestPropertiesDstsConfiguration dstsConfiguration) {
        this.dstsConfiguration = dstsConfiguration;
        return this;
    }

    public NotificationOptions notificationOptions() {
        return this.notificationOptions;
    }

    public ResourceProviderManifestProperties withNotificationOptions(NotificationOptions notificationOptions) {
        this.notificationOptions = notificationOptions;
        return this;
    }

    public List<ResourceHydrationAccount> resourceHydrationAccounts() {
        return this.resourceHydrationAccounts;
    }

    public ResourceProviderManifestProperties withResourceHydrationAccounts(List<ResourceHydrationAccount> resourceHydrationAccounts) {
        this.resourceHydrationAccounts = resourceHydrationAccounts;
        return this;
    }

    public ResourceProviderManifestPropertiesNotificationSettings notificationSettings() {
        return this.notificationSettings;
    }

    public ResourceProviderManifestProperties withNotificationSettings(ResourceProviderManifestPropertiesNotificationSettings notificationSettings) {
        this.notificationSettings = notificationSettings;
        return this;
    }

    public List<ResourceProviderEndpoint> managementGroupGlobalNotificationEndpoints() {
        return this.managementGroupGlobalNotificationEndpoints;
    }

    public ResourceProviderManifestProperties withManagementGroupGlobalNotificationEndpoints(List<ResourceProviderEndpoint> managementGroupGlobalNotificationEndpoints) {
        this.managementGroupGlobalNotificationEndpoints = managementGroupGlobalNotificationEndpoints;
        return this;
    }

    public List<String> optionalFeatures() {
        return this.optionalFeatures;
    }

    public ResourceProviderManifestProperties withOptionalFeatures(List<String> optionalFeatures) {
        this.optionalFeatures = optionalFeatures;
        return this;
    }

    public ResourceProviderManifestPropertiesResourceGroupLockOptionDuringMove resourceGroupLockOptionDuringMove() {
        return this.resourceGroupLockOptionDuringMove;
    }

    public ResourceProviderManifestProperties withResourceGroupLockOptionDuringMove(ResourceProviderManifestPropertiesResourceGroupLockOptionDuringMove resourceGroupLockOptionDuringMove) {
        this.resourceGroupLockOptionDuringMove = resourceGroupLockOptionDuringMove;
        return this;
    }

    public ResourceProviderManifestPropertiesResponseOptions responseOptions() {
        return this.responseOptions;
    }

    public ResourceProviderManifestProperties withResponseOptions(ResourceProviderManifestPropertiesResponseOptions responseOptions) {
        this.responseOptions = responseOptions;
        return this;
    }

    public String legacyNamespace() {
        return this.legacyNamespace;
    }

    public ResourceProviderManifestProperties withLegacyNamespace(String legacyNamespace) {
        this.legacyNamespace = legacyNamespace;
        return this;
    }

    public List<String> legacyRegistrations() {
        return this.legacyRegistrations;
    }

    public ResourceProviderManifestProperties withLegacyRegistrations(List<String> legacyRegistrations) {
        this.legacyRegistrations = legacyRegistrations;
        return this;
    }

    public String customManifestVersion() {
        return this.customManifestVersion;
    }

    public ResourceProviderManifestProperties withCustomManifestVersion(String customManifestVersion) {
        this.customManifestVersion = customManifestVersion;
        return this;
    }

    public void validate() {
        if (this.providerAuthentication() != null) {
            this.providerAuthentication().validate();
        }
        if (this.providerAuthorizations() != null) {
            this.providerAuthorizations().forEach(e -> e.validate());
        }
        if (this.services() != null) {
            this.services().forEach(e -> e.validate());
        }
        if (this.featuresRule() != null) {
            this.featuresRule().validate();
        }
        if (this.requestHeaderOptions() != null) {
            this.requestHeaderOptions().validate();
        }
        if (this.management() != null) {
            this.management().validate();
        }
        if (this.capabilities() != null) {
            this.capabilities().forEach(e -> e.validate());
        }
        if (this.templateDeploymentOptions() != null) {
            this.templateDeploymentOptions().validate();
        }
        if (this.globalNotificationEndpoints() != null) {
            this.globalNotificationEndpoints().forEach(e -> e.validate());
        }
        if (this.notifications() != null) {
            this.notifications().forEach(e -> e.validate());
        }
        if (this.linkedNotificationRules() != null) {
            this.linkedNotificationRules().forEach(e -> e.validate());
        }
        if (this.resourceProviderAuthorizationRules() != null) {
            this.resourceProviderAuthorizationRules().validate();
        }
        if (this.dstsConfiguration() != null) {
            this.dstsConfiguration().validate();
        }
        if (this.resourceHydrationAccounts() != null) {
            this.resourceHydrationAccounts().forEach(e -> e.validate());
        }
        if (this.notificationSettings() != null) {
            this.notificationSettings().validate();
        }
        if (this.managementGroupGlobalNotificationEndpoints() != null) {
            this.managementGroupGlobalNotificationEndpoints().forEach(e -> e.validate());
        }
        if (this.resourceGroupLockOptionDuringMove() != null) {
            this.resourceGroupLockOptionDuringMove().validate();
        }
        if (this.responseOptions() != null) {
            this.responseOptions().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("providerAuthentication", (JsonSerializable)this.providerAuthentication);
        jsonWriter.writeArrayField("providerAuthorizations", this.providerAuthorizations, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("namespace", this.namespace);
        jsonWriter.writeArrayField("services", this.services, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("serviceName", this.serviceName);
        jsonWriter.writeStringField("providerVersion", this.providerVersion);
        jsonWriter.writeStringField("providerType", this.providerType == null ? null : this.providerType.toString());
        jsonWriter.writeArrayField("requiredFeatures", this.requiredFeatures, (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("featuresRule", (JsonSerializable)this.featuresRule);
        jsonWriter.writeJsonField("requestHeaderOptions", (JsonSerializable)this.requestHeaderOptions);
        jsonWriter.writeJsonField("management", (JsonSerializable)this.management);
        jsonWriter.writeArrayField("capabilities", this.capabilities, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("crossTenantTokenValidation", this.crossTenantTokenValidation == null ? null : this.crossTenantTokenValidation.toString());
        if (this.metadata != null) {
            jsonWriter.writeUntypedField("metadata", this.metadata);
        }
        jsonWriter.writeJsonField("templateDeploymentOptions", (JsonSerializable)this.templateDeploymentOptions);
        jsonWriter.writeArrayField("globalNotificationEndpoints", this.globalNotificationEndpoints, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeBooleanField("enableTenantLinkedNotification", this.enableTenantLinkedNotification);
        jsonWriter.writeArrayField("notifications", this.notifications, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("linkedNotificationRules", this.linkedNotificationRules, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("resourceProviderAuthorizationRules", (JsonSerializable)this.resourceProviderAuthorizationRules);
        jsonWriter.writeJsonField("dstsConfiguration", (JsonSerializable)this.dstsConfiguration);
        jsonWriter.writeStringField("notificationOptions", this.notificationOptions == null ? null : this.notificationOptions.toString());
        jsonWriter.writeArrayField("resourceHydrationAccounts", this.resourceHydrationAccounts, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("notificationSettings", (JsonSerializable)this.notificationSettings);
        jsonWriter.writeArrayField("managementGroupGlobalNotificationEndpoints", this.managementGroupGlobalNotificationEndpoints, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("optionalFeatures", this.optionalFeatures, (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("resourceGroupLockOptionDuringMove", (JsonSerializable)this.resourceGroupLockOptionDuringMove);
        jsonWriter.writeJsonField("responseOptions", (JsonSerializable)this.responseOptions);
        jsonWriter.writeStringField("legacyNamespace", this.legacyNamespace);
        jsonWriter.writeArrayField("legacyRegistrations", this.legacyRegistrations, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("customManifestVersion", this.customManifestVersion);
        return jsonWriter.writeEndObject();
    }

    public static ResourceProviderManifestProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ResourceProviderManifestProperties)jsonReader.readObject(reader -> {
            ResourceProviderManifestProperties deserializedResourceProviderManifestProperties = new ResourceProviderManifestProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("providerAuthentication".equals(fieldName)) {
                    deserializedResourceProviderManifestProperties.providerAuthentication = ResourceProviderManifestPropertiesProviderAuthentication.fromJson(reader);
                    continue;
                }
                if ("providerAuthorizations".equals(fieldName)) {
                    List providerAuthorizations;
                    deserializedResourceProviderManifestProperties.providerAuthorizations = providerAuthorizations = reader.readArray(reader1 -> ResourceProviderAuthorization.fromJson(reader1));
                    continue;
                }
                if ("namespace".equals(fieldName)) {
                    deserializedResourceProviderManifestProperties.namespace = reader.getString();
                    continue;
                }
                if ("services".equals(fieldName)) {
                    List services;
                    deserializedResourceProviderManifestProperties.services = services = reader.readArray(reader1 -> ResourceProviderService.fromJson(reader1));
                    continue;
                }
                if ("serviceName".equals(fieldName)) {
                    deserializedResourceProviderManifestProperties.serviceName = reader.getString();
                    continue;
                }
                if ("providerVersion".equals(fieldName)) {
                    deserializedResourceProviderManifestProperties.providerVersion = reader.getString();
                    continue;
                }
                if ("providerType".equals(fieldName)) {
                    deserializedResourceProviderManifestProperties.providerType = ResourceProviderType.fromString(reader.getString());
                    continue;
                }
                if ("requiredFeatures".equals(fieldName)) {
                    List requiredFeatures;
                    deserializedResourceProviderManifestProperties.requiredFeatures = requiredFeatures = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("featuresRule".equals(fieldName)) {
                    deserializedResourceProviderManifestProperties.featuresRule = ResourceProviderManifestPropertiesFeaturesRule.fromJson(reader);
                    continue;
                }
                if ("requestHeaderOptions".equals(fieldName)) {
                    deserializedResourceProviderManifestProperties.requestHeaderOptions = ResourceProviderManifestPropertiesRequestHeaderOptions.fromJson(reader);
                    continue;
                }
                if ("management".equals(fieldName)) {
                    deserializedResourceProviderManifestProperties.management = ResourceProviderManifestPropertiesManagement.fromJson(reader);
                    continue;
                }
                if ("capabilities".equals(fieldName)) {
                    List capabilities;
                    deserializedResourceProviderManifestProperties.capabilities = capabilities = reader.readArray(reader1 -> ResourceProviderCapabilities.fromJson(reader1));
                    continue;
                }
                if ("crossTenantTokenValidation".equals(fieldName)) {
                    deserializedResourceProviderManifestProperties.crossTenantTokenValidation = CrossTenantTokenValidation.fromString(reader.getString());
                    continue;
                }
                if ("metadata".equals(fieldName)) {
                    deserializedResourceProviderManifestProperties.metadata = reader.readUntyped();
                    continue;
                }
                if ("templateDeploymentOptions".equals(fieldName)) {
                    deserializedResourceProviderManifestProperties.templateDeploymentOptions = ResourceProviderManifestPropertiesTemplateDeploymentOptions.fromJson(reader);
                    continue;
                }
                if ("globalNotificationEndpoints".equals(fieldName)) {
                    List globalNotificationEndpoints;
                    deserializedResourceProviderManifestProperties.globalNotificationEndpoints = globalNotificationEndpoints = reader.readArray(reader1 -> ResourceProviderEndpoint.fromJson(reader1));
                    continue;
                }
                if ("enableTenantLinkedNotification".equals(fieldName)) {
                    deserializedResourceProviderManifestProperties.enableTenantLinkedNotification = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("notifications".equals(fieldName)) {
                    List notifications;
                    deserializedResourceProviderManifestProperties.notifications = notifications = reader.readArray(reader1 -> Notification.fromJson(reader1));
                    continue;
                }
                if ("linkedNotificationRules".equals(fieldName)) {
                    List linkedNotificationRules;
                    deserializedResourceProviderManifestProperties.linkedNotificationRules = linkedNotificationRules = reader.readArray(reader1 -> FanoutLinkedNotificationRule.fromJson(reader1));
                    continue;
                }
                if ("resourceProviderAuthorizationRules".equals(fieldName)) {
                    deserializedResourceProviderManifestProperties.resourceProviderAuthorizationRules = ResourceProviderAuthorizationRules.fromJson(reader);
                    continue;
                }
                if ("dstsConfiguration".equals(fieldName)) {
                    deserializedResourceProviderManifestProperties.dstsConfiguration = ResourceProviderManifestPropertiesDstsConfiguration.fromJson(reader);
                    continue;
                }
                if ("notificationOptions".equals(fieldName)) {
                    deserializedResourceProviderManifestProperties.notificationOptions = NotificationOptions.fromString(reader.getString());
                    continue;
                }
                if ("resourceHydrationAccounts".equals(fieldName)) {
                    List resourceHydrationAccounts;
                    deserializedResourceProviderManifestProperties.resourceHydrationAccounts = resourceHydrationAccounts = reader.readArray(reader1 -> ResourceHydrationAccount.fromJson(reader1));
                    continue;
                }
                if ("notificationSettings".equals(fieldName)) {
                    deserializedResourceProviderManifestProperties.notificationSettings = ResourceProviderManifestPropertiesNotificationSettings.fromJson(reader);
                    continue;
                }
                if ("managementGroupGlobalNotificationEndpoints".equals(fieldName)) {
                    List managementGroupGlobalNotificationEndpoints;
                    deserializedResourceProviderManifestProperties.managementGroupGlobalNotificationEndpoints = managementGroupGlobalNotificationEndpoints = reader.readArray(reader1 -> ResourceProviderEndpoint.fromJson(reader1));
                    continue;
                }
                if ("optionalFeatures".equals(fieldName)) {
                    List optionalFeatures;
                    deserializedResourceProviderManifestProperties.optionalFeatures = optionalFeatures = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("resourceGroupLockOptionDuringMove".equals(fieldName)) {
                    deserializedResourceProviderManifestProperties.resourceGroupLockOptionDuringMove = ResourceProviderManifestPropertiesResourceGroupLockOptionDuringMove.fromJson(reader);
                    continue;
                }
                if ("responseOptions".equals(fieldName)) {
                    deserializedResourceProviderManifestProperties.responseOptions = ResourceProviderManifestPropertiesResponseOptions.fromJson(reader);
                    continue;
                }
                if ("legacyNamespace".equals(fieldName)) {
                    deserializedResourceProviderManifestProperties.legacyNamespace = reader.getString();
                    continue;
                }
                if ("legacyRegistrations".equals(fieldName)) {
                    List legacyRegistrations;
                    deserializedResourceProviderManifestProperties.legacyRegistrations = legacyRegistrations = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("customManifestVersion".equals(fieldName)) {
                    deserializedResourceProviderManifestProperties.customManifestVersion = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedResourceProviderManifestProperties;
        });
    }
}

