/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.providerhub.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.providerhub.models.ResourceAccessPolicy;
import com.azure.resourcemanager.providerhub.models.ResourceAccessRole;
import com.azure.resourcemanager.providerhub.models.ResourceProviderManagement;
import com.azure.resourcemanager.providerhub.models.ResourceProviderManagementErrorResponseMessageOptions;
import com.azure.resourcemanager.providerhub.models.ResourceProviderManagementExpeditedRolloutMetadata;
import com.azure.resourcemanager.providerhub.models.ServiceTreeInfo;
import java.io.IOException;
import java.util.List;

public final class ResourceProviderManifestManagement
extends ResourceProviderManagement {
    @Override
    public ResourceProviderManifestManagement withSchemaOwners(List<String> schemaOwners) {
        super.withSchemaOwners(schemaOwners);
        return this;
    }

    @Override
    public ResourceProviderManifestManagement withManifestOwners(List<String> manifestOwners) {
        super.withManifestOwners(manifestOwners);
        return this;
    }

    @Override
    public ResourceProviderManifestManagement withAuthorizationOwners(List<String> authorizationOwners) {
        super.withAuthorizationOwners(authorizationOwners);
        return this;
    }

    @Override
    public ResourceProviderManifestManagement withIncidentRoutingService(String incidentRoutingService) {
        super.withIncidentRoutingService(incidentRoutingService);
        return this;
    }

    @Override
    public ResourceProviderManifestManagement withIncidentRoutingTeam(String incidentRoutingTeam) {
        super.withIncidentRoutingTeam(incidentRoutingTeam);
        return this;
    }

    @Override
    public ResourceProviderManifestManagement withIncidentContactEmail(String incidentContactEmail) {
        super.withIncidentContactEmail(incidentContactEmail);
        return this;
    }

    @Override
    public ResourceProviderManifestManagement withServiceTreeInfos(List<ServiceTreeInfo> serviceTreeInfos) {
        super.withServiceTreeInfos(serviceTreeInfos);
        return this;
    }

    @Override
    public ResourceProviderManifestManagement withResourceAccessPolicy(ResourceAccessPolicy resourceAccessPolicy) {
        super.withResourceAccessPolicy(resourceAccessPolicy);
        return this;
    }

    @Override
    public ResourceProviderManifestManagement withResourceAccessRoles(List<ResourceAccessRole> resourceAccessRoles) {
        super.withResourceAccessRoles(resourceAccessRoles);
        return this;
    }

    @Override
    public ResourceProviderManifestManagement withExpeditedRolloutSubmitters(List<String> expeditedRolloutSubmitters) {
        super.withExpeditedRolloutSubmitters(expeditedRolloutSubmitters);
        return this;
    }

    @Override
    public ResourceProviderManifestManagement withErrorResponseMessageOptions(ResourceProviderManagementErrorResponseMessageOptions errorResponseMessageOptions) {
        super.withErrorResponseMessageOptions(errorResponseMessageOptions);
        return this;
    }

    @Override
    public ResourceProviderManifestManagement withExpeditedRolloutMetadata(ResourceProviderManagementExpeditedRolloutMetadata expeditedRolloutMetadata) {
        super.withExpeditedRolloutMetadata(expeditedRolloutMetadata);
        return this;
    }

    @Override
    public ResourceProviderManifestManagement withCanaryManifestOwners(List<String> canaryManifestOwners) {
        super.withCanaryManifestOwners(canaryManifestOwners);
        return this;
    }

    @Override
    public ResourceProviderManifestManagement withPcCode(String pcCode) {
        super.withPcCode(pcCode);
        return this;
    }

    @Override
    public ResourceProviderManifestManagement withProfitCenterProgramId(String profitCenterProgramId) {
        super.withProfitCenterProgramId(profitCenterProgramId);
        return this;
    }

    @Override
    public void validate() {
        if (this.serviceTreeInfos() != null) {
            this.serviceTreeInfos().forEach(e -> e.validate());
        }
        if (this.resourceAccessRoles() != null) {
            this.resourceAccessRoles().forEach(e -> e.validate());
        }
        if (this.errorResponseMessageOptions() != null) {
            this.errorResponseMessageOptions().validate();
        }
        if (this.expeditedRolloutMetadata() != null) {
            this.expeditedRolloutMetadata().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("schemaOwners", this.schemaOwners(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("manifestOwners", this.manifestOwners(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("authorizationOwners", this.authorizationOwners(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("incidentRoutingService", this.incidentRoutingService());
        jsonWriter.writeStringField("incidentRoutingTeam", this.incidentRoutingTeam());
        jsonWriter.writeStringField("incidentContactEmail", this.incidentContactEmail());
        jsonWriter.writeArrayField("serviceTreeInfos", this.serviceTreeInfos(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("resourceAccessPolicy", this.resourceAccessPolicy() == null ? null : this.resourceAccessPolicy().toString());
        jsonWriter.writeArrayField("resourceAccessRoles", this.resourceAccessRoles(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("expeditedRolloutSubmitters", this.expeditedRolloutSubmitters(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("errorResponseMessageOptions", (JsonSerializable)this.errorResponseMessageOptions());
        jsonWriter.writeJsonField("expeditedRolloutMetadata", (JsonSerializable)this.expeditedRolloutMetadata());
        jsonWriter.writeArrayField("canaryManifestOwners", this.canaryManifestOwners(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("pcCode", this.pcCode());
        jsonWriter.writeStringField("profitCenterProgramId", this.profitCenterProgramId());
        return jsonWriter.writeEndObject();
    }

    public static ResourceProviderManifestManagement fromJson(JsonReader jsonReader) throws IOException {
        return (ResourceProviderManifestManagement)jsonReader.readObject(reader -> {
            ResourceProviderManifestManagement deserializedResourceProviderManifestManagement = new ResourceProviderManifestManagement();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("schemaOwners".equals(fieldName)) {
                    List schemaOwners = reader.readArray(reader1 -> reader1.getString());
                    deserializedResourceProviderManifestManagement.withSchemaOwners(schemaOwners);
                    continue;
                }
                if ("manifestOwners".equals(fieldName)) {
                    List manifestOwners = reader.readArray(reader1 -> reader1.getString());
                    deserializedResourceProviderManifestManagement.withManifestOwners(manifestOwners);
                    continue;
                }
                if ("authorizationOwners".equals(fieldName)) {
                    List authorizationOwners = reader.readArray(reader1 -> reader1.getString());
                    deserializedResourceProviderManifestManagement.withAuthorizationOwners(authorizationOwners);
                    continue;
                }
                if ("incidentRoutingService".equals(fieldName)) {
                    deserializedResourceProviderManifestManagement.withIncidentRoutingService(reader.getString());
                    continue;
                }
                if ("incidentRoutingTeam".equals(fieldName)) {
                    deserializedResourceProviderManifestManagement.withIncidentRoutingTeam(reader.getString());
                    continue;
                }
                if ("incidentContactEmail".equals(fieldName)) {
                    deserializedResourceProviderManifestManagement.withIncidentContactEmail(reader.getString());
                    continue;
                }
                if ("serviceTreeInfos".equals(fieldName)) {
                    List serviceTreeInfos = reader.readArray(reader1 -> ServiceTreeInfo.fromJson(reader1));
                    deserializedResourceProviderManifestManagement.withServiceTreeInfos(serviceTreeInfos);
                    continue;
                }
                if ("resourceAccessPolicy".equals(fieldName)) {
                    deserializedResourceProviderManifestManagement.withResourceAccessPolicy(ResourceAccessPolicy.fromString(reader.getString()));
                    continue;
                }
                if ("resourceAccessRoles".equals(fieldName)) {
                    List resourceAccessRoles = reader.readArray(reader1 -> ResourceAccessRole.fromJson(reader1));
                    deserializedResourceProviderManifestManagement.withResourceAccessRoles(resourceAccessRoles);
                    continue;
                }
                if ("expeditedRolloutSubmitters".equals(fieldName)) {
                    List expeditedRolloutSubmitters = reader.readArray(reader1 -> reader1.getString());
                    deserializedResourceProviderManifestManagement.withExpeditedRolloutSubmitters(expeditedRolloutSubmitters);
                    continue;
                }
                if ("errorResponseMessageOptions".equals(fieldName)) {
                    deserializedResourceProviderManifestManagement.withErrorResponseMessageOptions(ResourceProviderManagementErrorResponseMessageOptions.fromJson(reader));
                    continue;
                }
                if ("expeditedRolloutMetadata".equals(fieldName)) {
                    deserializedResourceProviderManifestManagement.withExpeditedRolloutMetadata(ResourceProviderManagementExpeditedRolloutMetadata.fromJson(reader));
                    continue;
                }
                if ("canaryManifestOwners".equals(fieldName)) {
                    List canaryManifestOwners = reader.readArray(reader1 -> reader1.getString());
                    deserializedResourceProviderManifestManagement.withCanaryManifestOwners(canaryManifestOwners);
                    continue;
                }
                if ("pcCode".equals(fieldName)) {
                    deserializedResourceProviderManifestManagement.withPcCode(reader.getString());
                    continue;
                }
                if ("profitCenterProgramId".equals(fieldName)) {
                    deserializedResourceProviderManifestManagement.withProfitCenterProgramId(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedResourceProviderManifestManagement;
        });
    }
}

