/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.providerhub.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.providerhub.models.ResourceAccessPolicy;
import com.azure.resourcemanager.providerhub.models.ResourceAccessRole;
import com.azure.resourcemanager.providerhub.models.ResourceProviderManagementErrorResponseMessageOptions;
import com.azure.resourcemanager.providerhub.models.ResourceProviderManagementExpeditedRolloutMetadata;
import com.azure.resourcemanager.providerhub.models.ServiceTreeInfo;
import java.io.IOException;
import java.util.List;

public class ResourceProviderManagement
implements JsonSerializable<ResourceProviderManagement> {
    private List<String> schemaOwners;
    private List<String> manifestOwners;
    private List<String> authorizationOwners;
    private String incidentRoutingService;
    private String incidentRoutingTeam;
    private String incidentContactEmail;
    private List<ServiceTreeInfo> serviceTreeInfos;
    private ResourceAccessPolicy resourceAccessPolicy;
    private List<ResourceAccessRole> resourceAccessRoles;
    private List<String> expeditedRolloutSubmitters;
    private ResourceProviderManagementErrorResponseMessageOptions errorResponseMessageOptions;
    private ResourceProviderManagementExpeditedRolloutMetadata expeditedRolloutMetadata;
    private List<String> canaryManifestOwners;
    private String pcCode;
    private String profitCenterProgramId;

    public List<String> schemaOwners() {
        return this.schemaOwners;
    }

    public ResourceProviderManagement withSchemaOwners(List<String> schemaOwners) {
        this.schemaOwners = schemaOwners;
        return this;
    }

    public List<String> manifestOwners() {
        return this.manifestOwners;
    }

    public ResourceProviderManagement withManifestOwners(List<String> manifestOwners) {
        this.manifestOwners = manifestOwners;
        return this;
    }

    public List<String> authorizationOwners() {
        return this.authorizationOwners;
    }

    public ResourceProviderManagement withAuthorizationOwners(List<String> authorizationOwners) {
        this.authorizationOwners = authorizationOwners;
        return this;
    }

    public String incidentRoutingService() {
        return this.incidentRoutingService;
    }

    public ResourceProviderManagement withIncidentRoutingService(String incidentRoutingService) {
        this.incidentRoutingService = incidentRoutingService;
        return this;
    }

    public String incidentRoutingTeam() {
        return this.incidentRoutingTeam;
    }

    public ResourceProviderManagement withIncidentRoutingTeam(String incidentRoutingTeam) {
        this.incidentRoutingTeam = incidentRoutingTeam;
        return this;
    }

    public String incidentContactEmail() {
        return this.incidentContactEmail;
    }

    public ResourceProviderManagement withIncidentContactEmail(String incidentContactEmail) {
        this.incidentContactEmail = incidentContactEmail;
        return this;
    }

    public List<ServiceTreeInfo> serviceTreeInfos() {
        return this.serviceTreeInfos;
    }

    public ResourceProviderManagement withServiceTreeInfos(List<ServiceTreeInfo> serviceTreeInfos) {
        this.serviceTreeInfos = serviceTreeInfos;
        return this;
    }

    public ResourceAccessPolicy resourceAccessPolicy() {
        return this.resourceAccessPolicy;
    }

    public ResourceProviderManagement withResourceAccessPolicy(ResourceAccessPolicy resourceAccessPolicy) {
        this.resourceAccessPolicy = resourceAccessPolicy;
        return this;
    }

    public List<ResourceAccessRole> resourceAccessRoles() {
        return this.resourceAccessRoles;
    }

    public ResourceProviderManagement withResourceAccessRoles(List<ResourceAccessRole> resourceAccessRoles) {
        this.resourceAccessRoles = resourceAccessRoles;
        return this;
    }

    public List<String> expeditedRolloutSubmitters() {
        return this.expeditedRolloutSubmitters;
    }

    public ResourceProviderManagement withExpeditedRolloutSubmitters(List<String> expeditedRolloutSubmitters) {
        this.expeditedRolloutSubmitters = expeditedRolloutSubmitters;
        return this;
    }

    public ResourceProviderManagementErrorResponseMessageOptions errorResponseMessageOptions() {
        return this.errorResponseMessageOptions;
    }

    public ResourceProviderManagement withErrorResponseMessageOptions(ResourceProviderManagementErrorResponseMessageOptions errorResponseMessageOptions) {
        this.errorResponseMessageOptions = errorResponseMessageOptions;
        return this;
    }

    public ResourceProviderManagementExpeditedRolloutMetadata expeditedRolloutMetadata() {
        return this.expeditedRolloutMetadata;
    }

    public ResourceProviderManagement withExpeditedRolloutMetadata(ResourceProviderManagementExpeditedRolloutMetadata expeditedRolloutMetadata) {
        this.expeditedRolloutMetadata = expeditedRolloutMetadata;
        return this;
    }

    public List<String> canaryManifestOwners() {
        return this.canaryManifestOwners;
    }

    public ResourceProviderManagement withCanaryManifestOwners(List<String> canaryManifestOwners) {
        this.canaryManifestOwners = canaryManifestOwners;
        return this;
    }

    public String pcCode() {
        return this.pcCode;
    }

    public ResourceProviderManagement withPcCode(String pcCode) {
        this.pcCode = pcCode;
        return this;
    }

    public String profitCenterProgramId() {
        return this.profitCenterProgramId;
    }

    public ResourceProviderManagement withProfitCenterProgramId(String profitCenterProgramId) {
        this.profitCenterProgramId = profitCenterProgramId;
        return this;
    }

    public void validate() {
        if (this.serviceTreeInfos() != null) {
            this.serviceTreeInfos().forEach(e -> e.validate());
        }
        if (this.resourceAccessRoles() != null) {
            this.resourceAccessRoles().forEach(e -> e.validate());
        }
        if (this.errorResponseMessageOptions() != null) {
            this.errorResponseMessageOptions().validate();
        }
        if (this.expeditedRolloutMetadata() != null) {
            this.expeditedRolloutMetadata().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("schemaOwners", this.schemaOwners, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("manifestOwners", this.manifestOwners, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("authorizationOwners", this.authorizationOwners, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("incidentRoutingService", this.incidentRoutingService);
        jsonWriter.writeStringField("incidentRoutingTeam", this.incidentRoutingTeam);
        jsonWriter.writeStringField("incidentContactEmail", this.incidentContactEmail);
        jsonWriter.writeArrayField("serviceTreeInfos", this.serviceTreeInfos, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("resourceAccessPolicy", this.resourceAccessPolicy == null ? null : this.resourceAccessPolicy.toString());
        jsonWriter.writeArrayField("resourceAccessRoles", this.resourceAccessRoles, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("expeditedRolloutSubmitters", this.expeditedRolloutSubmitters, (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("errorResponseMessageOptions", (JsonSerializable)this.errorResponseMessageOptions);
        jsonWriter.writeJsonField("expeditedRolloutMetadata", (JsonSerializable)this.expeditedRolloutMetadata);
        jsonWriter.writeArrayField("canaryManifestOwners", this.canaryManifestOwners, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("pcCode", this.pcCode);
        jsonWriter.writeStringField("profitCenterProgramId", this.profitCenterProgramId);
        return jsonWriter.writeEndObject();
    }

    public static ResourceProviderManagement fromJson(JsonReader jsonReader) throws IOException {
        return (ResourceProviderManagement)jsonReader.readObject(reader -> {
            ResourceProviderManagement deserializedResourceProviderManagement = new ResourceProviderManagement();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("schemaOwners".equals(fieldName)) {
                    List schemaOwners;
                    deserializedResourceProviderManagement.schemaOwners = schemaOwners = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("manifestOwners".equals(fieldName)) {
                    List manifestOwners;
                    deserializedResourceProviderManagement.manifestOwners = manifestOwners = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("authorizationOwners".equals(fieldName)) {
                    List authorizationOwners;
                    deserializedResourceProviderManagement.authorizationOwners = authorizationOwners = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("incidentRoutingService".equals(fieldName)) {
                    deserializedResourceProviderManagement.incidentRoutingService = reader.getString();
                    continue;
                }
                if ("incidentRoutingTeam".equals(fieldName)) {
                    deserializedResourceProviderManagement.incidentRoutingTeam = reader.getString();
                    continue;
                }
                if ("incidentContactEmail".equals(fieldName)) {
                    deserializedResourceProviderManagement.incidentContactEmail = reader.getString();
                    continue;
                }
                if ("serviceTreeInfos".equals(fieldName)) {
                    List serviceTreeInfos;
                    deserializedResourceProviderManagement.serviceTreeInfos = serviceTreeInfos = reader.readArray(reader1 -> ServiceTreeInfo.fromJson(reader1));
                    continue;
                }
                if ("resourceAccessPolicy".equals(fieldName)) {
                    deserializedResourceProviderManagement.resourceAccessPolicy = ResourceAccessPolicy.fromString(reader.getString());
                    continue;
                }
                if ("resourceAccessRoles".equals(fieldName)) {
                    List resourceAccessRoles;
                    deserializedResourceProviderManagement.resourceAccessRoles = resourceAccessRoles = reader.readArray(reader1 -> ResourceAccessRole.fromJson(reader1));
                    continue;
                }
                if ("expeditedRolloutSubmitters".equals(fieldName)) {
                    List expeditedRolloutSubmitters;
                    deserializedResourceProviderManagement.expeditedRolloutSubmitters = expeditedRolloutSubmitters = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("errorResponseMessageOptions".equals(fieldName)) {
                    deserializedResourceProviderManagement.errorResponseMessageOptions = ResourceProviderManagementErrorResponseMessageOptions.fromJson(reader);
                    continue;
                }
                if ("expeditedRolloutMetadata".equals(fieldName)) {
                    deserializedResourceProviderManagement.expeditedRolloutMetadata = ResourceProviderManagementExpeditedRolloutMetadata.fromJson(reader);
                    continue;
                }
                if ("canaryManifestOwners".equals(fieldName)) {
                    List canaryManifestOwners;
                    deserializedResourceProviderManagement.canaryManifestOwners = canaryManifestOwners = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("pcCode".equals(fieldName)) {
                    deserializedResourceProviderManagement.pcCode = reader.getString();
                    continue;
                }
                if ("profitCenterProgramId".equals(fieldName)) {
                    deserializedResourceProviderManagement.profitCenterProgramId = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedResourceProviderManagement;
        });
    }
}

