/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.providerhub.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.providerhub.models.EndpointType;
import com.azure.resourcemanager.providerhub.models.ResourceProviderEndpointFeaturesRule;
import java.io.IOException;
import java.time.Duration;
import java.util.List;

public final class ResourceProviderEndpoint
implements JsonSerializable<ResourceProviderEndpoint> {
    private Boolean enabled;
    private List<String> apiVersions;
    private String endpointUri;
    private List<String> locations;
    private List<String> requiredFeatures;
    private ResourceProviderEndpointFeaturesRule featuresRule;
    private Duration timeout;
    private EndpointType endpointType;
    private String skuLink;

    public Boolean enabled() {
        return this.enabled;
    }

    public ResourceProviderEndpoint withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public List<String> apiVersions() {
        return this.apiVersions;
    }

    public ResourceProviderEndpoint withApiVersions(List<String> apiVersions) {
        this.apiVersions = apiVersions;
        return this;
    }

    public String endpointUri() {
        return this.endpointUri;
    }

    public ResourceProviderEndpoint withEndpointUri(String endpointUri) {
        this.endpointUri = endpointUri;
        return this;
    }

    public List<String> locations() {
        return this.locations;
    }

    public ResourceProviderEndpoint withLocations(List<String> locations) {
        this.locations = locations;
        return this;
    }

    public List<String> requiredFeatures() {
        return this.requiredFeatures;
    }

    public ResourceProviderEndpoint withRequiredFeatures(List<String> requiredFeatures) {
        this.requiredFeatures = requiredFeatures;
        return this;
    }

    public ResourceProviderEndpointFeaturesRule featuresRule() {
        return this.featuresRule;
    }

    public ResourceProviderEndpoint withFeaturesRule(ResourceProviderEndpointFeaturesRule featuresRule) {
        this.featuresRule = featuresRule;
        return this;
    }

    public Duration timeout() {
        return this.timeout;
    }

    public ResourceProviderEndpoint withTimeout(Duration timeout) {
        this.timeout = timeout;
        return this;
    }

    public EndpointType endpointType() {
        return this.endpointType;
    }

    public ResourceProviderEndpoint withEndpointType(EndpointType endpointType) {
        this.endpointType = endpointType;
        return this;
    }

    public String skuLink() {
        return this.skuLink;
    }

    public ResourceProviderEndpoint withSkuLink(String skuLink) {
        this.skuLink = skuLink;
        return this;
    }

    public void validate() {
        if (this.featuresRule() != null) {
            this.featuresRule().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("enabled", this.enabled);
        jsonWriter.writeArrayField("apiVersions", this.apiVersions, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("endpointUri", this.endpointUri);
        jsonWriter.writeArrayField("locations", this.locations, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("requiredFeatures", this.requiredFeatures, (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("featuresRule", (JsonSerializable)this.featuresRule);
        jsonWriter.writeStringField("timeout", CoreUtils.durationToStringWithDays((Duration)this.timeout));
        jsonWriter.writeStringField("endpointType", this.endpointType == null ? null : this.endpointType.toString());
        jsonWriter.writeStringField("skuLink", this.skuLink);
        return jsonWriter.writeEndObject();
    }

    public static ResourceProviderEndpoint fromJson(JsonReader jsonReader) throws IOException {
        return (ResourceProviderEndpoint)jsonReader.readObject(reader -> {
            ResourceProviderEndpoint deserializedResourceProviderEndpoint = new ResourceProviderEndpoint();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("enabled".equals(fieldName)) {
                    deserializedResourceProviderEndpoint.enabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("apiVersions".equals(fieldName)) {
                    List apiVersions;
                    deserializedResourceProviderEndpoint.apiVersions = apiVersions = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("endpointUri".equals(fieldName)) {
                    deserializedResourceProviderEndpoint.endpointUri = reader.getString();
                    continue;
                }
                if ("locations".equals(fieldName)) {
                    List locations;
                    deserializedResourceProviderEndpoint.locations = locations = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("requiredFeatures".equals(fieldName)) {
                    List requiredFeatures;
                    deserializedResourceProviderEndpoint.requiredFeatures = requiredFeatures = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("featuresRule".equals(fieldName)) {
                    deserializedResourceProviderEndpoint.featuresRule = ResourceProviderEndpointFeaturesRule.fromJson(reader);
                    continue;
                }
                if ("timeout".equals(fieldName)) {
                    deserializedResourceProviderEndpoint.timeout = (Duration)reader.getNullable(nonNullReader -> Duration.parse(nonNullReader.getString()));
                    continue;
                }
                if ("endpointType".equals(fieldName)) {
                    deserializedResourceProviderEndpoint.endpointType = EndpointType.fromString(reader.getString());
                    continue;
                }
                if ("skuLink".equals(fieldName)) {
                    deserializedResourceProviderEndpoint.skuLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedResourceProviderEndpoint;
        });
    }
}

