/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.providerhub.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.providerhub.models.ResourceProviderCapabilitiesEffect;
import java.io.IOException;
import java.util.List;

public final class ResourceProviderCapabilities
implements JsonSerializable<ResourceProviderCapabilities> {
    private String quotaId;
    private ResourceProviderCapabilitiesEffect effect;
    private List<String> requiredFeatures;
    private static final ClientLogger LOGGER = new ClientLogger(ResourceProviderCapabilities.class);

    public String quotaId() {
        return this.quotaId;
    }

    public ResourceProviderCapabilities withQuotaId(String quotaId) {
        this.quotaId = quotaId;
        return this;
    }

    public ResourceProviderCapabilitiesEffect effect() {
        return this.effect;
    }

    public ResourceProviderCapabilities withEffect(ResourceProviderCapabilitiesEffect effect) {
        this.effect = effect;
        return this;
    }

    public List<String> requiredFeatures() {
        return this.requiredFeatures;
    }

    public ResourceProviderCapabilities withRequiredFeatures(List<String> requiredFeatures) {
        this.requiredFeatures = requiredFeatures;
        return this;
    }

    public void validate() {
        if (this.quotaId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property quotaId in model ResourceProviderCapabilities"));
        }
        if (this.effect() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property effect in model ResourceProviderCapabilities"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("quotaId", this.quotaId);
        jsonWriter.writeStringField("effect", this.effect == null ? null : this.effect.toString());
        jsonWriter.writeArrayField("requiredFeatures", this.requiredFeatures, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static ResourceProviderCapabilities fromJson(JsonReader jsonReader) throws IOException {
        return (ResourceProviderCapabilities)jsonReader.readObject(reader -> {
            ResourceProviderCapabilities deserializedResourceProviderCapabilities = new ResourceProviderCapabilities();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("quotaId".equals(fieldName)) {
                    deserializedResourceProviderCapabilities.quotaId = reader.getString();
                    continue;
                }
                if ("effect".equals(fieldName)) {
                    deserializedResourceProviderCapabilities.effect = ResourceProviderCapabilitiesEffect.fromString(reader.getString());
                    continue;
                }
                if ("requiredFeatures".equals(fieldName)) {
                    List requiredFeatures;
                    deserializedResourceProviderCapabilities.requiredFeatures = requiredFeatures = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedResourceProviderCapabilities;
        });
    }
}

