/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.providerhub.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.providerhub.models.AdditionalAuthorization;
import java.io.IOException;
import java.util.List;

public final class ResourceProviderAuthorizationManagedByAuthorization
implements JsonSerializable<ResourceProviderAuthorizationManagedByAuthorization> {
    private List<AdditionalAuthorization> additionalAuthorizations;
    private String managedByResourceRoleDefinitionId;
    private Boolean allowManagedByInheritance;

    public List<AdditionalAuthorization> additionalAuthorizations() {
        return this.additionalAuthorizations;
    }

    public ResourceProviderAuthorizationManagedByAuthorization withAdditionalAuthorizations(List<AdditionalAuthorization> additionalAuthorizations) {
        this.additionalAuthorizations = additionalAuthorizations;
        return this;
    }

    public String managedByResourceRoleDefinitionId() {
        return this.managedByResourceRoleDefinitionId;
    }

    public ResourceProviderAuthorizationManagedByAuthorization withManagedByResourceRoleDefinitionId(String managedByResourceRoleDefinitionId) {
        this.managedByResourceRoleDefinitionId = managedByResourceRoleDefinitionId;
        return this;
    }

    public Boolean allowManagedByInheritance() {
        return this.allowManagedByInheritance;
    }

    public ResourceProviderAuthorizationManagedByAuthorization withAllowManagedByInheritance(Boolean allowManagedByInheritance) {
        this.allowManagedByInheritance = allowManagedByInheritance;
        return this;
    }

    public void validate() {
        if (this.additionalAuthorizations() != null) {
            this.additionalAuthorizations().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("additionalAuthorizations", this.additionalAuthorizations, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("managedByResourceRoleDefinitionId", this.managedByResourceRoleDefinitionId);
        jsonWriter.writeBooleanField("allowManagedByInheritance", this.allowManagedByInheritance);
        return jsonWriter.writeEndObject();
    }

    public static ResourceProviderAuthorizationManagedByAuthorization fromJson(JsonReader jsonReader) throws IOException {
        return (ResourceProviderAuthorizationManagedByAuthorization)jsonReader.readObject(reader -> {
            ResourceProviderAuthorizationManagedByAuthorization deserializedResourceProviderAuthorizationManagedByAuthorization = new ResourceProviderAuthorizationManagedByAuthorization();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("additionalAuthorizations".equals(fieldName)) {
                    List additionalAuthorizations;
                    deserializedResourceProviderAuthorizationManagedByAuthorization.additionalAuthorizations = additionalAuthorizations = reader.readArray(reader1 -> AdditionalAuthorization.fromJson(reader1));
                    continue;
                }
                if ("managedByResourceRoleDefinitionId".equals(fieldName)) {
                    deserializedResourceProviderAuthorizationManagedByAuthorization.managedByResourceRoleDefinitionId = reader.getString();
                    continue;
                }
                if ("allowManagedByInheritance".equals(fieldName)) {
                    deserializedResourceProviderAuthorizationManagedByAuthorization.allowManagedByInheritance = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedResourceProviderAuthorizationManagedByAuthorization;
        });
    }
}

