/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.providerhub.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.providerhub.models.ResourceProviderAuthorizationManagedByAuthorization;
import com.azure.resourcemanager.providerhub.models.ThirdPartyExtension;
import java.io.IOException;
import java.util.List;

public final class ResourceProviderAuthorization
implements JsonSerializable<ResourceProviderAuthorization> {
    private String applicationId;
    private String roleDefinitionId;
    private String managedByRoleDefinitionId;
    private ResourceProviderAuthorizationManagedByAuthorization managedByAuthorization;
    private List<ThirdPartyExtension> allowedThirdPartyExtensions;
    private String groupingTag;

    public String applicationId() {
        return this.applicationId;
    }

    public ResourceProviderAuthorization withApplicationId(String applicationId) {
        this.applicationId = applicationId;
        return this;
    }

    public String roleDefinitionId() {
        return this.roleDefinitionId;
    }

    public ResourceProviderAuthorization withRoleDefinitionId(String roleDefinitionId) {
        this.roleDefinitionId = roleDefinitionId;
        return this;
    }

    public String managedByRoleDefinitionId() {
        return this.managedByRoleDefinitionId;
    }

    public ResourceProviderAuthorization withManagedByRoleDefinitionId(String managedByRoleDefinitionId) {
        this.managedByRoleDefinitionId = managedByRoleDefinitionId;
        return this;
    }

    public ResourceProviderAuthorizationManagedByAuthorization managedByAuthorization() {
        return this.managedByAuthorization;
    }

    public ResourceProviderAuthorization withManagedByAuthorization(ResourceProviderAuthorizationManagedByAuthorization managedByAuthorization) {
        this.managedByAuthorization = managedByAuthorization;
        return this;
    }

    public List<ThirdPartyExtension> allowedThirdPartyExtensions() {
        return this.allowedThirdPartyExtensions;
    }

    public ResourceProviderAuthorization withAllowedThirdPartyExtensions(List<ThirdPartyExtension> allowedThirdPartyExtensions) {
        this.allowedThirdPartyExtensions = allowedThirdPartyExtensions;
        return this;
    }

    public String groupingTag() {
        return this.groupingTag;
    }

    public ResourceProviderAuthorization withGroupingTag(String groupingTag) {
        this.groupingTag = groupingTag;
        return this;
    }

    public void validate() {
        if (this.managedByAuthorization() != null) {
            this.managedByAuthorization().validate();
        }
        if (this.allowedThirdPartyExtensions() != null) {
            this.allowedThirdPartyExtensions().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("applicationId", this.applicationId);
        jsonWriter.writeStringField("roleDefinitionId", this.roleDefinitionId);
        jsonWriter.writeStringField("managedByRoleDefinitionId", this.managedByRoleDefinitionId);
        jsonWriter.writeJsonField("managedByAuthorization", (JsonSerializable)this.managedByAuthorization);
        jsonWriter.writeArrayField("allowedThirdPartyExtensions", this.allowedThirdPartyExtensions, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("groupingTag", this.groupingTag);
        return jsonWriter.writeEndObject();
    }

    public static ResourceProviderAuthorization fromJson(JsonReader jsonReader) throws IOException {
        return (ResourceProviderAuthorization)jsonReader.readObject(reader -> {
            ResourceProviderAuthorization deserializedResourceProviderAuthorization = new ResourceProviderAuthorization();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("applicationId".equals(fieldName)) {
                    deserializedResourceProviderAuthorization.applicationId = reader.getString();
                    continue;
                }
                if ("roleDefinitionId".equals(fieldName)) {
                    deserializedResourceProviderAuthorization.roleDefinitionId = reader.getString();
                    continue;
                }
                if ("managedByRoleDefinitionId".equals(fieldName)) {
                    deserializedResourceProviderAuthorization.managedByRoleDefinitionId = reader.getString();
                    continue;
                }
                if ("managedByAuthorization".equals(fieldName)) {
                    deserializedResourceProviderAuthorization.managedByAuthorization = ResourceProviderAuthorizationManagedByAuthorization.fromJson(reader);
                    continue;
                }
                if ("allowedThirdPartyExtensions".equals(fieldName)) {
                    List allowedThirdPartyExtensions;
                    deserializedResourceProviderAuthorization.allowedThirdPartyExtensions = allowedThirdPartyExtensions = reader.readArray(reader1 -> ThirdPartyExtension.fromJson(reader1));
                    continue;
                }
                if ("groupingTag".equals(fieldName)) {
                    deserializedResourceProviderAuthorization.groupingTag = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedResourceProviderAuthorization;
        });
    }
}

