/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.providerhub.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public class ResourceProviderAuthentication
implements JsonSerializable<ResourceProviderAuthentication> {
    private List<String> allowedAudiences;
    private static final ClientLogger LOGGER = new ClientLogger(ResourceProviderAuthentication.class);

    public List<String> allowedAudiences() {
        return this.allowedAudiences;
    }

    public ResourceProviderAuthentication withAllowedAudiences(List<String> allowedAudiences) {
        this.allowedAudiences = allowedAudiences;
        return this;
    }

    public void validate() {
        if (this.allowedAudiences() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property allowedAudiences in model ResourceProviderAuthentication"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("allowedAudiences", this.allowedAudiences, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static ResourceProviderAuthentication fromJson(JsonReader jsonReader) throws IOException {
        return (ResourceProviderAuthentication)jsonReader.readObject(reader -> {
            ResourceProviderAuthentication deserializedResourceProviderAuthentication = new ResourceProviderAuthentication();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("allowedAudiences".equals(fieldName)) {
                    List allowedAudiences;
                    deserializedResourceProviderAuthentication.allowedAudiences = allowedAudiences = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedResourceProviderAuthentication;
        });
    }
}

