/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.providerhub.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public class ResourceMovePolicy
implements JsonSerializable<ResourceMovePolicy> {
    private Boolean validationRequired;
    private Boolean crossResourceGroupMoveEnabled;
    private Boolean crossSubscriptionMoveEnabled;

    public Boolean validationRequired() {
        return this.validationRequired;
    }

    public ResourceMovePolicy withValidationRequired(Boolean validationRequired) {
        this.validationRequired = validationRequired;
        return this;
    }

    public Boolean crossResourceGroupMoveEnabled() {
        return this.crossResourceGroupMoveEnabled;
    }

    public ResourceMovePolicy withCrossResourceGroupMoveEnabled(Boolean crossResourceGroupMoveEnabled) {
        this.crossResourceGroupMoveEnabled = crossResourceGroupMoveEnabled;
        return this;
    }

    public Boolean crossSubscriptionMoveEnabled() {
        return this.crossSubscriptionMoveEnabled;
    }

    public ResourceMovePolicy withCrossSubscriptionMoveEnabled(Boolean crossSubscriptionMoveEnabled) {
        this.crossSubscriptionMoveEnabled = crossSubscriptionMoveEnabled;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("validationRequired", this.validationRequired);
        jsonWriter.writeBooleanField("crossResourceGroupMoveEnabled", this.crossResourceGroupMoveEnabled);
        jsonWriter.writeBooleanField("crossSubscriptionMoveEnabled", this.crossSubscriptionMoveEnabled);
        return jsonWriter.writeEndObject();
    }

    public static ResourceMovePolicy fromJson(JsonReader jsonReader) throws IOException {
        return (ResourceMovePolicy)jsonReader.readObject(reader -> {
            ResourceMovePolicy deserializedResourceMovePolicy = new ResourceMovePolicy();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("validationRequired".equals(fieldName)) {
                    deserializedResourceMovePolicy.validationRequired = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("crossResourceGroupMoveEnabled".equals(fieldName)) {
                    deserializedResourceMovePolicy.crossResourceGroupMoveEnabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("crossSubscriptionMoveEnabled".equals(fieldName)) {
                    deserializedResourceMovePolicy.crossSubscriptionMoveEnabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedResourceMovePolicy;
        });
    }
}

