/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.providerhub.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class ResourceManagementEntity
implements JsonSerializable<ResourceManagementEntity> {
    private String resourceId;
    private String homeTenantId;
    private String location;
    private String status;
    private static final ClientLogger LOGGER = new ClientLogger(ResourceManagementEntity.class);

    public String resourceId() {
        return this.resourceId;
    }

    public ResourceManagementEntity withResourceId(String resourceId) {
        this.resourceId = resourceId;
        return this;
    }

    public String homeTenantId() {
        return this.homeTenantId;
    }

    public ResourceManagementEntity withHomeTenantId(String homeTenantId) {
        this.homeTenantId = homeTenantId;
        return this;
    }

    public String location() {
        return this.location;
    }

    public ResourceManagementEntity withLocation(String location) {
        this.location = location;
        return this;
    }

    public String status() {
        return this.status;
    }

    public void validate() {
        if (this.resourceId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property resourceId in model ResourceManagementEntity"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("resourceId", this.resourceId);
        jsonWriter.writeStringField("homeTenantId", this.homeTenantId);
        jsonWriter.writeStringField("location", this.location);
        return jsonWriter.writeEndObject();
    }

    public static ResourceManagementEntity fromJson(JsonReader jsonReader) throws IOException {
        return (ResourceManagementEntity)jsonReader.readObject(reader -> {
            ResourceManagementEntity deserializedResourceManagementEntity = new ResourceManagementEntity();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("resourceId".equals(fieldName)) {
                    deserializedResourceManagementEntity.resourceId = reader.getString();
                    continue;
                }
                if ("homeTenantId".equals(fieldName)) {
                    deserializedResourceManagementEntity.homeTenantId = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedResourceManagementEntity.location = reader.getString();
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedResourceManagementEntity.status = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedResourceManagementEntity;
        });
    }
}

