/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.providerhub.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.providerhub.models.ResourceManagementEntity;
import java.io.IOException;
import java.util.List;

public final class ResourceManagementAction
implements JsonSerializable<ResourceManagementAction> {
    private List<ResourceManagementEntity> resources;

    public List<ResourceManagementEntity> resources() {
        return this.resources;
    }

    public ResourceManagementAction withResources(List<ResourceManagementEntity> resources) {
        this.resources = resources;
        return this;
    }

    public void validate() {
        if (this.resources() != null) {
            this.resources().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("resources", this.resources, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static ResourceManagementAction fromJson(JsonReader jsonReader) throws IOException {
        return (ResourceManagementAction)jsonReader.readObject(reader -> {
            ResourceManagementAction deserializedResourceManagementAction = new ResourceManagementAction();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("resources".equals(fieldName)) {
                    List resources;
                    deserializedResourceManagementAction.resources = resources = reader.readArray(reader1 -> ResourceManagementEntity.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedResourceManagementAction;
        });
    }
}

